#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/common/RCS/bridgefall.c,v 1.7 89/05/10 04:03:59 muir Exp $";
#endif

/*
 * bridgefall.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "path.h"
#include "file.h"
#include "xy.h"

bridgefall(sp)
	struct	sctstr *sp;
{
	register int i;
	register int j;
	struct	sctstr sect;
	struct	sctstr bh_sect;
	int	nx;
	int	ny;
	int	nnx;
	int	nny;
	int	mines;

	for (i = 1; i <= 6; i++) {
		nx = sp->sct_x + diroff[i][0];
		ny = sp->sct_y + diroff[i][1];
		getsect(nx, ny, &sect);
		if (sect.sct_type != SCT_BSPAN)
			continue;
		for (j = 1; j <= 6; j++) {
			nnx = nx + diroff[j][0];
			nny = ny + diroff[j][1];
			if (nnx == sp->sct_x && nny == sp->sct_y)
				continue;
			getsect(nnx, nny, &bh_sect);
			if (bh_sect.sct_type == SCT_BHEAD)
				break;
		}
		if (j > 6) {
			wu(0, (int) sect.sct_own,
				fmt("Crumble... SCREEEECH!  Splash! at %s\n",
				ownxy(&sect)));
			sect.sct_type = SCT_WATER;
			sect.sct_newtype = SCT_WATER;
			sect.sct_own = 0;
			sect.sct_oldown = 0;
			/*
			 * save only the mines; zero the rest of the
			 * commodities.
			 */
			mines = getvar(V_MINE, (caddr_t)&sect, EF_SECTOR);
			sect.sct_nv = 0;
			if (mines > 0)
				(void) putvar(V_MINE, mines, (caddr_t)&sect,
					EF_SECTOR);
			(void) putsect(&sect);
		}
	}
}
