#ifndef lint
static char *RCSid = "$Header: trdsub.c,v 1.5 88/05/04 00:55:13 c188-cz Exp $";
#endif

/*
 * trdsub.c
 *
 * trade read/write of the trade file.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include <sys/uio.h>
#include "var.h"
#include "trade.h"
#include "nat.h"

int	commf;

int	c_comm[MAXNOC][I_MAX+1];
float	c_price[MAXNOC][I_MAX+1];
float	c_mult[MAXNOC][MAXNOC];

static	struct iovec tradevec[3] = {
	(caddr_t)c_comm,	sizeof(c_comm),
	(caddr_t)c_price,	sizeof(c_price),
	(caddr_t)c_mult,	sizeof(c_mult),
};
static	int nvec = sizeof(tradevec)/sizeof(struct iovec);

/*
 * comm file is the list of "deity commodities"
 * lying around.  Perhaps a better way of doing this
 * might be at each update seeing what is on sale,
 * then buying it, then distributing things amongst the
 * people wanting the items.
  *
 * Of course that would be a gigantic pain...
 */

int
commread()
{
	(void) lseek(commf, (off_t) 0, 0);
	if (readv(commf, tradevec, nvec) != nvec)
		return -1;
	return 0;
}

int
commwrite()
{
	(void) lseek(commf, (off_t) 0, 0);
	if (writev(commf, tradevec, nvec) != nvec)
		return -1;
	return 0;
}

int
commlock() 
{
	return file_lock(commf);
}

communlock()
{
	file_unlock(commf);
}

/*
 * returns amount of commodity, and price to the user
 */
int
commamt(trader, product, priceval)
	int	trader;
	int	product;
	float	*priceval;
{
	*priceval = c_price[trader][product] * c_mult[trader][cnum];
	return c_comm[trader][product];
}

commset(trader, product, amt)
	int	trader;
	int	product;
	int	amt;
{
	c_comm[trader][product] += amt;
}

double
multread(trader, tradee)
	int	trader;
	int	tradee;
{
	return c_mult[trader][tradee];
}

multset(tradee, newmult)
	int	tradee;
	float	newmult;
{
	c_mult[cnum][tradee] = newmult;
}

commprice(product, newprice)
	int	product;
	float	*newprice;
{
	c_price[cnum][product] = *newprice;
}
