static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/SUBS/RCS/tm_subr.c,v 1.2 89/05/10 01:45:56 muir Exp $";

/*
 * tm_subr.c
 *
 * routines for connecting to and communicating with
 * the transaction manager.
 *
 * Dave Pare, 1986
 */

#include <errno.h>
#include <signal.h>
#include "misc.h"
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/time.h>
#include <stdio.h>
#include <sys/file.h>
#include <varargs.h>
#include "nat.h"
#include "tm.h"
#include "sailio.h"
#include "user.h"
#include "file.h"

SAIL	*iop;
int	tm_answer[10];
int	tm_seq = 0;

int
tm_connect()
{
	extern	char gamedir[];
	int	s;
	struct	sockaddr_un un;
	char	buf[80];

	(void) sprintf(un.sun_path, "%s/tm_socket", gamedir);
	un.sun_family = AF_UNIX;
	if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
		perror("socket");
		return 0;
	}
	if (connect(s, (struct sockaddr *) &un, strlen(un.sun_path)+2) < 0) {
		perror("unix socket connect");
		return 0;
	}
	iop = sopen(s);
	(void) sprintf(buf, "%d %d %d %d\n", C_IDENT, tm_seq++, getpid(), cnum);
	sputs(buf, iop);
	sflush(iop);
	return 1;
}

tm_flush()
{
	sflush(iop);
}

/*
 * Send a sync packet, and wait until we receive
 * acknowledgement for it...like the X XSync() call.
 */
int
tm_sync(ms)
	int	ms;
{
	char	buf[32];
	int	seq;

	sprintf(buf, "%d %d 0 0\n", C_SYNC, tm_seq);
	seq = tm_seq++;
	sputs(buf, iop);
	sflush(iop);
	if (sio_input(iop) && tm_update(seq) > 0)
		return 1;
	do {
		sio_clr(iop);
		siowait(iop, ms);
		if (sio_err(iop)) {
			pr("tm_sync: I/O error\n");
			return 0;
		}
		if (sio_timeout(iop)) {
			pr(fmt("tm_sync: timing out (%d)\n", ms));
			return 0;
		}
	} while (tm_update(seq) <= 0);
	return 1;
}

tm_wait(ms)
	int	ms;
{
	siowait(iop, ms);
}

int
tm_lock(p, cmd)
	SAIL	*p;
	int	cmd;
{
	char	buf[80];
	int	n;

	sprintf(buf, "%d %d 0 %d\n", C_LOCK, tm_seq, cmd);
	sputs(buf, p);
	sflush(p);
	sio_clr(p);
retry:
	siowait(p, 2000);
	if (sio_timeout(p)) {
		do {
			pr("Waiting on lock...\n");
			(void) fflush(stdout);
			sio_clr(p);
			siowait(p, 5000);
		} while (sio_timeout(p));
	}
	if ((n = tm_update(tm_seq)) == 0) {
		pr("Updating nation file...\n");
		goto retry;
	}
	tm_seq++;
	if (n < 0) {
		pr("Lock failed; retry command.\n");
		return 0;
	}
	return 1;
}

int
tm_unlock(n)
	int	n;
{
	char	buf[80];

	sprintf(buf, "%d %d %d\n", C_UNLOCK, tm_seq, n);
	sputs(buf, iop);
	sflush(iop);
retry:
	sio_clr(iop);
	siowait(iop, 2000);
	if (sio_timeout(iop)) {
		do {
			pr("Waiting to unlock...\n");
			(void) fflush(stdout);
			sio_clr(iop);
			siowait(iop, 5000);
		} while (sio_timeout(iop));
	}
	if ((n = tm_update(tm_seq)) < 0) {
		pr("tm_unlock: file was not locked!\n");
		tm_seq++;
		return 0;
	}
	if (n == 0) {
		pr("Updating nation file...\n");
		goto retry;
	}
	tm_seq++;
	return 1;
}

int
tm_update(wantseq)
	int	wantseq;
{
	char	buf[80];
	int	ok;
	int	seq;
	int	offs;

	ok = 0;
	/*
	 * don't wait on tm_update since socket is noblock anyhow
	 */
	while (sgets(buf, sizeof(buf), iop, 0) != 0) {
		if (tm_parse(buf) == 0)
			continue;
		seq = tm_answer[1];
		/* tm_answer[2] (which) is ignored now */
		offs = tm_answer[3];
		switch (tm_answer[0]) {
		case TM_MOD:
			if (offs < 0) {
				pr("rereading nat file...\n");
				ef_close(EF_NATION);
				ef_open(EF_NATION, O_RDONLY, EFF_MEM);
			} else
				natmod(buf, tm_answer);
			break;
		case TM_OK:
			if (wantseq >= 0 && seq == wantseq)
				ok = 1;
			break;
		case TM_ERROR:
			if (wantseq >= 0 && seq == wantseq)
				ok = -1;
			break;
		case TM_PANIC:
		default:
			/* don't worry about seq #'s on panics */
			logerror("tm_update: panic; buf %s", buf);
			bye_bye(1);
			break;
		}
	}
	if (sio_conn(iop)) {
		pr("tm_update: transaction manager died!\n");
		bye_bye(1);
	}
	if (sio_err(iop)) {
		pr(fmt("tm_update: tm sent error %d\n", sio_errno(iop)));
		sio_clrerr(iop);
		ok = -1;
	}
	return ok;
}

static
int
tm_parse(buf)
	char	*buf;
{
	char	*bp;
	int	i;

	bp = buf;
	for (i=0; i<10 && *bp; i++) {
		tm_answer[i] = atoip(&bp);
	}
	return i;
}

/*
 * nat_value takes a variable 5th param. The following stuff is an attempt
 * to get around machine dependencies. I think varargs handles most cases
 * of this sort of thing - its just a bit of a pain to set up!
 * JPO 5/88
 */
/*VARARGS*/
nat_value(va_alist)
	va_dcl
{
	va_list	ap;
	int	off;
	int	coun;
	int	n;
	int	how;
	char	val[80];
	char	buf[128];
	struct	fixnat *fp;
	struct	boundstr *bnd;

	va_start (ap);
	off = va_arg(ap, int);
	coun = va_arg(ap, int);
	n = va_arg(ap, int);
	how = va_arg(ap, int);
	if ((fp = natfield(off)) == 0) {
		logerror("nat_value: offset %d bad", off);
		return;
	}
	switch (fp->type) {
	case NF_CHAR:
		sprintf(val, "%d", va_arg(ap, int));
		break;
	case NF_SHORT:
		sprintf(val, "%d", va_arg(ap, int));
		break;
	case NF_LONG:
		sprintf(val, "%d", va_arg(ap, long));
		break;
	case NF_FLOAT:
		sprintf(val, "%f", va_arg(ap, double));
		break;
	case NF_DOUBLE:
		sprintf(val, "%f", va_arg(ap, double));
		break;
	case NF_STRING:
		strcpy(val, va_arg(ap, char *));
		break;
	case NF_BOUND:	/* pointer to struct -- portability */
		bnd = va_arg(ap, struct boundstr *);
		sprintf(val, "%d %d %d %d", bnd->b_xl,
			bnd->b_xh, bnd->b_yl, bnd->b_yh);
		break;
	default:
		pr(fmt("bad case value %d", fp->type));
		break;
	}
	sprintf(buf, "%d -1 %d %d %d %d %d \"%s\"\n", C_NATMOD,
		EF_NATION, coun, off, n, how, val);
	sputs(buf, iop);
	va_end(ap);
}
