#ifndef lint
static char *RCSid = "$Header: takeover.c 1.7 89/03/15 $";
#endif

/*
 * takeover.c
 *
 * take over from another power.
 * set up loyalty to new govt, old owner.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "plane.h"
#include "ship.h"
#include "file.h"

int
takeover(sp, mil)
	register struct sctstr *sp;
	int	mil;
{
	register struct plnstr *pp;
	int	civ;
	int	che;
	int	n;
	int	oldche;
	struct	nstr_item ni;
	struct	plnstr p;

	pp = &p;
	snxtitem_all(&ni, EF_PLANE);
	while (nxtitem(&ni, (caddr_t)pp)) {
		if (pp->pln_x != sp->sct_x || pp->pln_y != sp->sct_y)
			continue;
		if (pp->pln_own == cnum)
			continue;
		if (pp->pln_effic > 10)
			pp->pln_effic = 10;
		if (pp->pln_mobil > 0)
			pp->pln_mobil = 0;
		pp->pln_own = cnum;
		putplane(ni.cur, pp);
	}
	civ = getvar(V_CIVIL, (char *)sp, EF_SECTOR);
	/* zero current V_CHE target */
	oldche = getvar(V_CHE, (char *)sp, EF_SECTOR) & 0x3ff;
	/*
	 * create guerrillas from civilians
	 * how spunky are these guys?
	 * n: random number from -50:50 + 50
	 */
	n = (50 - sp->sct_loyal) + (random() % 100) - 50;
	che = 0;
	if (n > 0 && sp->sct_own == sp->sct_oldown) {
		che = (civ * n/3000) + 5;
		if (che * 2 > civ)
			che = civ / 2;
		if (che > 0) {
			civ -= che;
			(void) putvar(V_CHE, (cnum << 10) | (oldche + che),
				      (char *)sp, EF_SECTOR);
		} else
			che = 0;
	}
	if (sp->sct_oldown == cnum || civ == 0) {
		/*
		 * taking over one of your old sectors
		 */
		sp->sct_loyal = 0;
		sp->sct_oldown = cnum;
	} else {
		/*
		 * taking over someone else's sector
		 */
		sp->sct_loyal = 50;
	}
	sp->sct_own = cnum;
	return mil;
}

takeover_ship(sp, n)
	register struct shpstr *sp;
	int	n;
{
	register struct plnstr *pp;
	struct	mchrstr *mp;
	struct	nstr_item ni;
	struct	plnstr p;

	mp = &mchr[sp->shp_type];
	sp->shp_own = n;
	if ((mp->m_flags & (M_FLY|M_MSL)) == 0)
		return;
	pp = &p;
	snxtitem_all(&ni, EF_PLANE);
	while (nxtitem(&ni, (caddr_t)pp)) {
		if (pp->pln_ship != sp->shp_uid)
			continue;
		if (pp->pln_effic > 10)
			pp->pln_effic = 10;
		if (pp->pln_mobil > 0)
			pp->pln_mobil = 0;
		pp->pln_own = n;
		putplane(ni.cur, pp);
	}
}
