#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/SUBS/RCS/snxtitem.c,v 1.2 89/05/10 01:45:42 muir Exp $";
#endif

/*
 * snxtitem.c
 *
 * arrange item selection using one of many different
 * criteria.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "file.h"
#include "com.h"

/*
 * setup the nstr structure for sector selection.
 * can select on NS_ALL, NS_AREA, NS_DIST, and NS_LIST.
 * iterate thru the "condarg" string looking
 * for arguments to compile into the nstr.
 */
int
snxtitem(np, type, str)
	register struct nstr_item *np;
	int	type;
	char	*str;
{
	register char *cp;
	struct	range range;
	int	list[NS_LSIZE];
	int	n;
	coord	cx, cy;
	int	dist;

	if (str == 0 || *str == 0) {
		if ((str = getstring("(items)? ")) == 0)
			return 0;
	}
	switch (sarg_type(str)) {
	case NS_AREA:
		if (!sarg_area(str, &range))
			return 0;
		snxtitem_area(np, type, &range);
		break;
	case NS_DIST:
		if (!sarg_range(str, &cx, &cy, &dist))
			return 0;
		snxtitem_dist(np, type, cx, cy, dist);
		break;
	case NS_ALL:
		snxtitem_all(np, type);
		break;
	case NS_LIST:
		if ((n = sarg_list(str, list, NS_LSIZE)) == 0)
			return 0;
		if (!snxtitem_list(np, type, list, n))
			return 0;
		break;
	default:
		return 0;
	}
	if (condarg == 0)
		return 1;
	cp = condarg;
	while ((cp = nstr_comp(np->cond, &np->ncond, EF_SECTOR, cp)) && *cp)
		;
	if (cp == 0)
		return 0;
	return 1;
}

snxtitem_area(np, type, range)
	register struct nstr_item *np;
	int	type;
	struct	range *range;
{
	bzero(np, sizeof(*np));
	np->cur = -1;
	np->type = type;
	np->sel = NS_AREA;
	np->index = -1;
	np->range = *range;
	np->read = ef_read;
	ef_zapcache(type);
}

snxtitem_dist(np, type, cx, cy, dist)
	register struct nstr_item *np;
	int	cx, cy;
	int	dist;
{
	struct	range range;

	bzero(np, sizeof(*np));
	xydist_range(cx, cy, dist, &range);
	np->cur = -1;
	np->type = type;
	np->sel = NS_AREA;
	np->cx = cx;
	np->cy = cy;
	np->index = -1;
	np->range = range;
	np->dist = dist;
	np->read = ef_read;
	ef_zapcache(type);
}

snxtitem_all(np, type)
	register struct nstr_item *np;
	int	type;
{
	bzero(np, sizeof(*np));
	np->cur = -1;
	np->sel = NS_ALL;
	np->type = type;
	np->index = -1;
	np->read = ef_read;
	ef_zapcache(type);
}

snxtitem_rewind(np)
	struct	nstr_item *np;
{
	np->cur = -1;
	ef_zapcache(np->type);
}

int
snxtitem_list(np, type, list, len)
	register struct nstr_item *np;
	int	type;
	int	*list;
	int	len;
{
	int	i;

	bzero(np, sizeof(*np));
	np->cur = -1;
	np->type = type;
	np->sel = NS_LIST;
	np->index = -1;
	np->read = ef_read;
	if (len <= 0 || len > NS_LSIZE)
		return 0;
	for (i=0; i<len; i++)
		np->list[i] = list[i];
	np->size = len;
	ef_zapcache(type);
	return 1;
}
