#ifndef lint
static char *RCSid = "$Header: show.c 1.5 89/03/15 $";
#endif

/*
 * show.c
 *
 * general routines that are callable to give info on things.
 * currently, planes, ships, nukes and bridges. Tanks & regiments one day?
 *
 * Julian Onions, 1988
 */

#include "misc.h"
#include "nuke.h"
#include "var.h"
#include "ship.h"
#include "item.h"
#include "plane.h"

/*
 * This cruft really belongs in the empglb.c file.
 * Yuck.
 */

struct lookup {
	int     key;
	char   *value;
};

struct lookup  ship_flags[] = {
	M_FOOD, "fish",
	M_TORP, "torp",
	M_DCH, "dchrg",
	M_FLY, "plane",
	M_MSL, "miss",
	M_OIL, "oil",
	M_SONAR, "sonar",
	M_MINE, "mine",
	M_SWEEP, "sweep",
	M_SUB, "sub",
	M_SPY, "spy",
	M_LAND, "land",
	0, 0
};

struct lookup  plane_flags[] = {
	P_T, "tactical",
	P_B, "bomber",
	P_F, "intercept",
	P_C, "cargo",
	P_V, "VTOL",
	P_M, "missile",
	P_L, "light",
	P_S, "spy",
	P_I, "image",
	P_O, "satellite",
	P_X, "stealth",
	0, 0
};

static
char *
lookup(key, table)
	int     key;
	struct lookup *table;
{
	int	match;

	if ((match = intmatch(key, &table->key, sizeof(*table))) < 0)
		return 0;
	return table[match].value;
}

show_bridge(tlev)
	int     tlev;
{
	extern double buil_bt, buil_bc;
	extern int buil_bh;

	if (tlev < buil_bt)
		return;
	pr(fmt("Bridges require %g tech, %d hcm, %d workers and cost $%g\n",
	       buil_bt, buil_bh, buil_bh * 2, buil_bc));
}

show_nuke_build(tlev)
	int     tlev;
{
	register struct nchrstr *np;
	register int n;

	pr(fmt("%13s lcm hcm  oil  rad tech $\n", ""));
	for (np = nchr, n = 0; n < nuk_maxno; np++, n++) {
		if (np->n_tech > tlev)
			continue;
		if (np->n_name == 0 || np->n_name[0] == '\0')
			continue;
		pr(fmt("%-13.13s %3d %3d %4d %4d %4d $%d\n",
		       np->n_name, np->n_lcm, np->n_hcm,
		       np->n_oil, np->n_rad, np->n_tech,
		       np->n_cost));
	}
}

show_nuke_capab(tlev)
	int     tlev;
{
	register struct nchrstr *np;
	register int n;

	pr(fmt("%13s blst dam lbs tech $\n", ""));
	for (np = nchr, n = 0; n < nuk_maxno; np++, n++) {
		if (np->n_tech > tlev)
			continue;
		if (np->n_name == 0 || np->n_name[0] == '\0')
			continue;
		pr(fmt("%-13.13s %4d %3d %3d %4d $%d\n",
		       np->n_name, np->n_blast, np->n_dam,
		       np->n_weight, np->n_tech, np->n_cost));
	}
}

show_ship_build(tlev)
	int     tlev;
{
	register struct mchrstr *mp;
	register int n;

	pr(fmt("%13s lcm hcm tech  $\n", ""));
	for (mp = mchr, n = 0; n < shp_maxno; n++, mp++) {
		if (mp->m_tech > tlev)
			continue;
		if (mp->m_name == 0 || mp->m_name[0] == '\0')
			continue;
		pr(fmt("%-13.13s %3d %3d %4d $%d\n",
		       mp->m_name, mp->m_lcm, mp->m_hcm,
		       mp->m_tech, mp->m_cost));
	}
}

show_ship_capab(tlev)
	int     tlev;
{
	register struct mchrstr *mp;
	register short *ap;
	register u_char *type;
	register int i;
	register int it;
	int     scount;
	int     n;
	char    c;
	char   *p;

	pr(fmt("%13s def spd vis spy rng fir cargoes & abilities\n", ""));
	for (mp = mchr, scount = 0; scount < shp_maxno; scount++, mp++) {
		if (mp->m_tech > tlev)
			continue;
		if (mp->m_name == 0 || mp->m_name[0] == '\0')
			continue;
		pr(fmt("%-13.13s %3d %3d %3d %3d %3d %3d",
		       mp->m_name, mp->m_armor, mp->m_speed,
		       mp->m_visib, mp->m_vrnge, mp->m_frnge,
		       mp->m_glim));
		for (ap = mp->m_vamt, type = mp->m_vtype, i = 0;
		     i < mp->m_nv; i++, ap++, type++) {
			it = unitem((int) *type);
			if (it > 0 && it < maxitem && ichr[it].i_name != 0)
				c = ichr[it].i_name[0];
			else
				c = '?';
			pr(fmt(" %d%c", *ap, c));
		}
		pr(" ");
		for (i = n = 0; i < 32; i++) {
			if (!(mp->m_flags & bit(i)))
				continue;
			if (p = lookup(bit(i), ship_flags)) {
				if (n++ > 0)
					pr(" ");
				pr(p);
			}
		}
		pr("\n");
	}
}

show_plane_capab(tlev)
	int     tlev;
{
	register struct plchrstr *pp;
	register int i;
	int     pcount;
	int     n;
	char   *p;

	pr(fmt("%13s acc load att def ran fuel abilites\n", ""));
	for (pp = plchr, pcount = 0; pcount < pln_maxno; pcount++, pp++) {
		if (pp->pl_tech > tlev)
			continue;
		if (pp->pl_name == 0 || pp->pl_name[0] == '\0')
			continue;
		pr(fmt("%-13.13s %3d %4d %3d %3d %3d %4d ",
		       pp->pl_name, pp->pl_acc, pp->pl_load,
		       pp->pl_att, pp->pl_def, pp->pl_range,
		       pp->pl_fuel));
		for (i = n = 0; i < 32; i++) {
			if (!(pp->pl_flags & bit(i)))
				continue;
			if (p = lookup(bit(i), plane_flags)) {
				if (n++ > 0)
					pr(" ");
				pr(p);
			}
		}
		pr("\n");
	}
}

show_plane_build(tlev)
	int     tlev;
{
	register struct plchrstr *pp;
	register int n;

	pr("              lcm hcm crew tech  $\n");
	for (pp = plchr, n = 0; n < pln_maxno; n++, pp++) {
		if (pp->pl_tech > tlev)
			continue;
		if (pp->pl_name == 0 || pp->pl_name[0] == '\0')
			continue;
		pr(fmt("%-13.13s %3d %3d %3d %4d $%d\n",
		       pp->pl_name, pp->pl_lcm,
		       pp->pl_hcm, pp->pl_crew,
		       pp->pl_tech, pp->pl_cost));
	}
}
