#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/SUBS/RCS/radmap.c,v 1.12 89/05/10 01:45:32 muir Exp $";
#endif

/*
 * radmap.c
 *
 * do a radar map given an x,y location, effic,
 * and other things.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "xy.h"
#include "nat.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"
#include "file.h"
#include "nsc.h"
#include "deity.h"

/*
 * XXX problem with range: not symmetric for some
 * values of range.  Very strange
 */
radmap(cx, cy, eff, range, seesub)
	int	cx;
	int	cy;
	int	eff;
	int	range;
	double	seesub;
{
#ifdef lint
	char rad[40][80];
#else
	register char rad[40][80];
#endif
	int	rng;
	struct	sctstr sect;
	struct	shpstr ship;
	struct	plnstr plane;
	struct	nstr_sect ns;
	struct	nstr_item ni;
	int	x, y;
	int	row;
	int	n;

	range *= (eff / 100.0);
	pr(fmt("%s efficiency %d%%, max range %d\n",
		xyas(cx, cy, cnum), eff, range));
	snxtsct_dist(&ns, cx, cy, range);
	n = deltay(ns.range.hy, ns.range.ly);
	blankfill((char *)rad, n + 1, sizeof(rad[0]));
	while (nxtsct(&ns, &sect)) {
		x = deltax(ns.x, ns.range.lx);
		y = deltay(ns.y, ns.range.ly);
		if (god || sect.sct_own == cnum || sect.sct_type <= SCT_RURAL ||
		    ns.curdist < ns.dist/8)
			rad[y][x] = dchr[sect.sct_type].d_mnem;
		else
			rad[y][x] = '?';
	}
	snxtitem_dist(&ni, EF_PLANE, cx, cy, range);
	while (nxtitem(&ni, (caddr_t)&plane)) {
		if (plane.pln_own == 0)
			continue;
		x = deltax((int)plane.pln_x, ns.range.lx);
		y = deltay((int)plane.pln_y, ns.range.ly);
		if (plane.pln_flags & PLN_LAUNCHED)
			rad[y][x] = '$';
	}
	snxtitem_dist(&ni, EF_SHIP, cx, cy, range);
	while (nxtitem(&ni, (caddr_t)&ship)) {
		if (ship.shp_own == 0)
			continue;
		x = deltax((int)ship.shp_x, ns.range.lx);
		y = deltay((int)ship.shp_y, ns.range.ly);
		/* XXX is below correct?  ni.curdist?? */
		rng = mchr[ship.shp_type].m_visib * ni.curdist / 20.0;
		if (ni.curdist > rng)
			continue;
		if ((mchr[ship.shp_type].m_flags & M_SUB) &&
		    ni.curdist > rng * seesub)
			continue;
		/* &~0x20 makes it a cap letter */
		rad[y][x] = (*mchr[ship.shp_type].m_name) & ~0x20;
	}
	/* 
	 * make the center of the display 0
	 * so ve et al can find it.
	 */
	rad[deltay(cy, ns.range.ly)][deltax(cx, ns.range.lx)] = '0';
	/* won't work for radar maps > WORLD_Y/2 */
	n = deltay(ns.range.hy, ns.range.ly);
	for (row=0; row < n; row++)
		pr(fmt("%s\n", rad[row]));
	pr("\n");
}
