#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/SUBS/RCS/pr.c,v 1.8 89/05/10 01:45:29 muir Exp $";
#endif

/*
 * pr.c
 *
 * The pr routine historically arranged for nonbuffered i/o
 * because stdio didn't used to automatically flush stdout before
 * it read something from stdin.  Now pr() prepends an "output id"
 * in front of each line of text, informing the user interface
 * what sort of item it is seeing; prompt, noecho prompt,
 * more input data, etc.
 *
 * Dave Pare, 1986, 1989
 */

#include <stdio.h>
#include <ctype.h>
#include <varargs.h>
#include "defs.h"
#include "misc.h"
#include "nat.h"
#include "sailio.h"

static	int bol = 1;

pr(buf)
	char *buf;
{
	register char *bp;
	register char c;
	register int local_bol;

	local_bol = bol;
	for (bp=buf; c = *bp; bp++) {
		if (local_bol)
			(void) outid(C_DATA);
		local_bol = 0;
		(void) putc(c, stdout);
		if (c == '\n')
			local_bol++;
	}
	bol = local_bol;
}

/*
 * highlighted characters have hex 80 or'ed in
 * with them to designate their highlightedness
 */
pr_hilite(buf)
	char *buf;
{
	register char *bp;
	register char c;
	register int local_bol;

	local_bol = bol;
	for (bp=buf; c = *bp; bp++) {
		if (local_bol)
			(void) outid(C_DATA);
		local_bol = 0;
		if (isprint(c))
			c |= 0x80;
		(void) putc(c, stdout);
		if (c == '\n')
			local_bol++;
	}
	bol = local_bol;
}

/* 
 * output 3 digit code plus space
 */
outid(n)
	register int n;
{
	(void) putc('0'+n/100, stdout);
	n %= 100;
	(void) putc('0'+n/10, stdout);
	n %= 10;
	(void) putc('0'+n, stdout);
	(void) putc(' ', stdout);
}

/*
 * informs user interface that it should immediately
 * flush it's stdout after receiving this line.  This
 * is probably a prompt.
 */
prflush(buf)
	char	*buf;
{
	register char *bp;
	register int c;

	if (!bol)
		(void) putc('\n', stdout);
	(void) outid(C_FLUSH);
	for (bp=buf; c = *bp; bp++) {
		(void) putc(c, stdout);
		if (c == '\n')
			(void) outid(C_FLUSH);
	}
	if (c != '\n') {
		(void) putc('\n', stdout);
		bol++;
	}
	if (fflush(stdout) < 0) {
		/*gencore();*/
		bye_bye(0);
	}
}

showvers(vers)
	char	*vers;
{
	(void) outid(C_INIT);
	puts(vers);
}

int
prmptrd(prompt, str, size)
	char	*prompt;
	register char *str;
	int	size;
{
	char	buf[255];
	char	cmd[20];
	int	n;

	prflush(prompt);
	if (recvclient(cmd, buf) == 0)
		return 0;
	(void) strncpy(str, buf, size);
	str[size-1] = 0;
	n = strlen(str);
	if (n == 0) {
		*str = 0;
		return 1;
	}
	if (*str == '\n') {
		*str = 0;
		return 1;
	}
	return n;
}

prdate()
{
	extern	long time();
	extern	char *ctime();
	long	now;

	(void) time(&now);
	pr(ctime(&now));
}
