#ifndef lint
static char *RCSid = "$Header: nxtitem.c 1.1 89/03/15 $";
#endif

/*
 * nxtitem.c
 *
 * get next item from list.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "plane.h"
#include "ship.h"
#include "nuke.h"
#include "unit.h"
#include "nsc.h"
#include "nat.h"

int
nxtitem(np, ptr)
	struct	nstr_item *np;
	caddr_t	ptr;
{
	struct	genstr *gp;

	gp = (struct genstr *) ptr;
	while (1) {
		if (np->sel == NS_LIST) {
			np->index++;
			if (np->index >= np->size)
				return 0;
			np->cur = np->list[np->index];
		} else {
			np->cur++;
		}
		if (!np->read(np->type, np->cur, ptr)) {
			/* if read fails, fatal */
			return 0;
		}
		if (np->sel == NS_LIST && !owner)
			continue;
		if (np->sel == NS_AREA || np->sel == NS_DIST) {
			if (gp->g_x < np->range.lx || gp->g_y > np->range.hx ||
			    gp->g_y < np->range.ly || gp->g_y > np->range.hy)
				continue;
		}
		if (np->sel == NS_DIST) {
			np->curdist = mapdist((int)gp->g_x, (int)gp->g_y,
				(int)np->cx, (int)np->cy);
			if (np->curdist > np->dist)
				continue;
		}
		if (np->ncond == 0 ||
		    nstr_exec(np->cond, np->ncond, ptr, np->type))
			break;
	}
	return 1;
}
