#ifndef lint
static char *RCSid = "$Header: getele.c 1.8 89/03/15 $";
#endif

/*
 * getele.c
 *
 * read a telegram from a file or stdin and send
 * it to the target country
 *
 * from PSL Empire, 1985
 */

#include <ctype.h>
#include "misc.h"
#include "tel.h"

int
getele(nation, buf)
	char *nation;
	char *buf;
{
	register char *bp;
	register int len;
	register int c;
	char	buffer[MAXTELSIZE+1];
	char	*left;

	pr(fmt("Enter telegram for %s; end with ^D or .\n", nation));
	bp = buf;
	for (;;) {
		left = fmt("%4d left: ", buf + MAXTELSIZE - bp);
		*buffer = 0;
		if (prmptrd(left, buffer, MAXTELSIZE) == 0)
			break;
		if (strcmp(".",buffer) == 0)
			break;
		len = strlen(buffer);
		buffer[len++] = '\n';
		buffer[len] = 0;
		if (len + (bp - buf) > MAXTELSIZE)
			pr("Too long.  Try that last line again...\n");
		else {
			if (buffer[0] == '>')		/* forgery attempt? */
				buffer[0] = '?';	/* foil it */
			(void) strcpy(bp, buffer);
			bp += len;
		}
	}
	len = bp - buf;
	buf[len] = 0;
	/*
	** Get rid of non-ASCII and control characters.
	*/
	for (bp = buf; c = *bp; bp++) {
		if (isascii(c) && (isprint(c) || isspace(c)))
			continue;
		*bp = '?';
	}
	return len;
}
