#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/SUBS/RCS/getbit.c,v 1.7 89/05/10 01:44:54 muir Exp $";
#endif

/*
 * getbit.c
 *
 * replaces old langston 1985 bitmap code
 *
 * David Muir Sharnoff, 1987
 */

#include "misc.h"
#include "xy.h"

int
getbit(x, y, bitmap)
	int	x;
	int	y;
	u_char	*bitmap;
{
	int	id;

	id = (y & (WORLD_Y-1)) * WORLD_X/2 + (x & (WORLD_X-1))/2;
	return bitmap[id / 8] & bit(id & 07);
}

setbitmap(x, y, bitmap, bitmaps)
	register int x;
	register int y;
	register u_char *bitmap;
	int	*bitmaps;
{
	register int *mp;
	register int id;
	register int dx, dy;

	for (mp = bitmaps; *mp != 9999; ) {
		dx = x + *mp++;
		dy = y + *mp++;
		id = (dy & (WORLD_Y-1)) * WORLD_X/2 + (dx & (WORLD_X-1))/2;
		bitmap[id / 8] |= bit(id & 07);
	}
}
