#ifndef lint
static char *RCSid = "$Header: distrea.c 1.5 89/03/15 $";
#endif

/*
 * distrea.c
 *
 * display treaty
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "treaty.h"
#include "nat.h"
#include "deity.h"
#include "file.h"

int
distrea(n, tp)
	int	n;
	register struct trtstr *tp;
{
	register int i;
	int	acond;
	int	bcond;
	int	cond;
	time_t	now;

	if (tp->trt_status == TS_FREE)
		return 0;
	if (tp->trt_cna != cnum && tp->trt_cnb != cnum && !god)
		return 0;
	(void) time(&now);
	if (now > tp->trt_exp) {
		pr(fmt("Treaty #%d expired %s", n, ctime(&tp->trt_exp)));
		tp->trt_status = TS_FREE;
		puttre(n, tp);
		return 0;
	}
	pr(fmt("\n      * * *  Empire Treaty #%d  * * *\n", n));
	if (tp->trt_status == TS_PROPOSED)
		pr("(proposed)\n");
	pr(fmt("between %s and ", cname(tp->trt_cna)));
	pr(fmt("%s  expires %s", cname(tp->trt_cnb), ctime(&tp->trt_exp)));
	pr(fmt("%14.14s terms", cname(tp->trt_cna)));
	pr(fmt("  %s terms\n", cname(tp->trt_cnb)));
	for (i = 0; cond = tchr[i].t_cond; i++) {
		acond = tp->trt_acond & cond;
		bcond = tp->trt_bcond & cond;
		if (acond | bcond) {
			if (acond)
				pr(fmt("%20s", tchr[i].t_name));
			else
				pr(fmt("%20s", ""));
			if (bcond)
				pr(fmt(" %s\n", tchr[i].t_name));
			else
				pr("\n");
		}
	}
	return 1;
}
