#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/SUBS/RCS/cnumb.c,v 1.6 89/05/10 01:44:22 muir Exp $";
#endif

/*
 * cnumb.c
 *
 * return country # given country name or
 * unambiguous country name match
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "file.h"

int
cnumb(cntry)
	char	*cntry;
{
	register char *ncp;
	register char *cp;
	register int n;
	register struct natstr *natp;
	int	best;
	int	bcount;

	best = -1;
	bcount = 0;
	for (n = 0; natp = getnatp(n); n++) {
		ncp = natp->nat_cnam;
		for (cp=cntry; *cp == *ncp; cp++, ncp++) {
			if (*cp == 0)
				return n;
		}
		if (cp > cntry && *cp == 0) {
			best = n;
			bcount++;
		}
	}
	/* can only have 1 match or not successful */
	if (bcount > 1)
		return -1;
	return best;
}
