#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/SUBS/RCS/border.c,v 1.6 89/05/10 01:43:46 muir Exp $";
#endif

/*
 * border.c
 *
 * create a border around a map
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "file.h"
#include "xy.h"

int
border(rp, prefstr, sep)
	struct	range *rp;
	char	*prefstr;	/* prefixes each line */
	char	*sep;		/* separates the numbers */
{
	register int i;
	register int posi;
	int	startx, endx;
	int	len;

	len = rp->hx - rp->lx;
	if (len < 0)
		len += WORLD_X;
	startx = rp->lx;
	endx = rp->hx;
#if (WORLD_X/2 > 100)
	if (rp->lx + len > 99 || rp->hx - len < -99) {
		/*
		 * hundreds
		 */
		pr(prefstr);
		i = startx;
		do {
			if (i >= WORLD_X/2)
				i -= WORLD_X;
			pr(sep);
			if (i < 0 && i > -100) {
				pr("-");
				continue;
			}
			posi = (i < 0 ? -i : i) / 100;
			pr(fmt("%d", posi % 10));
		} while (++i != endx);
		pr("\n");
	}
#endif
	/*
	 * tens
	 */
	pr(prefstr);
	i = startx;
	do {
		if (i >= WORLD_X/2)
			i -= WORLD_X;
		pr(sep);
		if (i < 0 && i > -10) {
			pr("-");
			continue;
		}
		posi = (i < 0 ? -i : i) / 10;
		pr(fmt("%d", posi % 10));
	} while (++i != endx);
	pr("\n");
	/*
	 * units...
	 */
	pr(prefstr);
	i = startx;
	do {
		if (i >= WORLD_X/2)
			i -= WORLD_X;
		posi = (i < 0 ? -i : i);
		pr(fmt("%s%d", sep, posi % 10));
	} while (++i != endx);
	pr("\n");
	return 1;
}
