static char *RCSid = "$Header: vers.c 1.18 89/03/17 $";

/*
 * vers.c
 *
 * empire version (probably out of date by now!)
 *
 * from PSL Empire, 1985
 */

#include <time.h>
#include "update.h"
#include "../../gamesdef.h"

vers()
{
	extern	char *fmt();
	extern	char *Version;
	extern	char *privname;
	extern	char *privlog;
	extern	int w_xsize, w_ysize;
	extern	int s_p_etu;
	extern	int upd_adj;
	extern	int maxnoc;
	extern	int m_m_p_d;
	extern	int players_at_00;
	extern	float btu_build_rate;
	extern	double fgrate, fcrate;
	extern	double eatrate, babyeat;
	extern	double obrate, uwbrate;
	extern	double bankint;
	extern	double hap_cons, edu_cons;
	extern	double money_civ, money_uw, money_mil, money_res;
	extern	float hap_avg, edu_avg, ally_factor;
	extern	float level_age_rate;
	extern	float easy_tech, hard_tech, tech_log_base;
	long	now;
	long	next_update;

	time(&now);
	next_update = now + (MOB_ETU * s_p_etu) - (now + upd_adj) 
		% (MOB_ETU * s_p_etu);

	pr(fmt("%s\n\n", Version));
	pr("The following parameters have been set for this game:\n");
	pr(fmt("World size is %d by %d.\n", w_xsize, w_ysize));
	pr(fmt("There can be up to %d countries.\n", maxnoc));
	pr(fmt("By default, countries use %s coordinate system.\n",
		(players_at_00) ? "the diety's" : "their own"));

#	ifdef WEATHER
		pr("This world has active weather.\n");
#	endif 

#	ifdef SHIPGAINCONSTANT
		pr("Ships gain efficiency at a constant rate.\n");
#	endif 

#	ifndef RANDOM
		pr("Updates are deterministic.\n");
#	endif

	pr("\n");

	pr(fmt("An Empire time unit is %d second%s long.\n",
		s_p_etu, s_p_etu == 1 ? "s" : ""));
	pr(fmt("The next update is at %19.19s.\n",ctime(&next_update)));
	pr(fmt("The current time is %19.19s.\n",ctime(&now)));
	pr(fmt("Mobility is updated every %d time units, sectors every %d.\n",
		MOB_ETU, PROD_ETU));
	pr(fmt("Each country is allowed to be logged in %d minutes a day.\n",
		m_m_p_d));
	pr(fmt("It takes %.2f civilians to produce a BTU in one time unit.\n",
		(1.0/(btu_build_rate*100.0))));
	pr("\n");


	pr(fmt("A non-aggi, 100 fertility sector can grow %.2f food per etu.\n",
		100.0 * fgrate));
	pr(fmt("1000 civilians will harvest %.1f food per etu.\n",
			1000.0*fcrate));
	pr(fmt("1000 civilians will give birth to %.1f babies per etu.\n", 
			1000.0*obrate));
	pr(fmt("1000 uncompensated workers will give birth to %.1f babies.\n", 
			1000.0*uwbrate));
	pr(fmt("In one time unit, 1000 people eat %.1f units of food.\n", 
			1000.0*eatrate));
	pr(fmt("1000 babies eat %.1f units of food becoming adults.\n", 
			1000.0*babyeat));
	pr("\n");


	pr(fmt("Banks pay $%.2f in interest per 1000 gold bars per etu.\n",
		bankint*1000.0));
	pr(fmt("1000 civilians generate $%.2f, uncompensated workers $%.2f each time unit.\n", 1000.0*money_civ, 1000.0*money_uw));
	pr(fmt("1000 active military cost $%.2f, reserves cost $%.2f.\n",
		-money_mil*1000.0, -money_res*1000.0));
	pr("\n");


	pr(fmt("Happiness p.e. requires 1 happy stroller per %d civ.\n",
		(int) hap_cons));
	pr(fmt("Education p.e. requires 1 class of graduates per %d civ.\n",
		(int) edu_cons));
	pr(fmt("Happiness is averaged over %d time units.\n", (int)hap_avg));
	pr(fmt("Education is averaged over %d time units.\n", (int)edu_avg));
	pr(fmt(
	"The technology/research boost you get from your allies is %.2f%%.\n",
		100.0/ally_factor));
	pr(fmt("Nation levels (tech etc.) decline 1%% every %d time units.\n",
		(int)(level_age_rate)));

	pr("Tech Buildup is ");
	if (tech_log_base <= 1.0 && hard_tech == 0.0) {
		pr("not limited\n");
	} 
	if (tech_log_base > 1.0) {
		pr(fmt("limited to logrithmic growth (base %.2f)",
			tech_log_base));
		if (easy_tech + tech_log_base == 0.0) 
			pr(".\n");
		else
			pr(fmt(" after %0.2f.\n", easy_tech + tech_log_base));
	} else {
		pr(fmt("limited to asymptotic growth towards %.2f",
			hard_tech + easy_tech));
		if (easy_tech == 0.00) 
			pr(".\n");
		else
			pr(fmt("after %.2f\n",easy_tech));
	}

	pr("\n");
	pr(fmt("The person to annoy if something goes wrong is %s\n\t\t(%s).\n",
		privname, privlog));
	pr(fmt("You can get your own copy of the source %s\n",GET_SOURCE));
	return 0;
}
