static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/trad.c,v 1.8 89/02/20 18:56:18 muir Exp $";

/*
 * $Log:	trad.c,v $
 * Revision 1.8  89/02/20  18:56:18  muir
 * after arthur patch 06
 * 
 * Revision 1.7  89/02/17  16:29:05  muir
 * after arthur patch 05:
 * can't put a plane in a <60% airfield.
 * 
 * Revision 1.6  89/02/11  15:59:22  muir
 * after mr-frog changes
 * 
 * Revision 1.5  88/09/24  23:34:16  muir
 * after cap changes
 * 
 * Revision 1.4  88/09/03  18:38:09  muir
 * after mr-frog patch 02
 * 
 * Revision 1.3  88/04/01  04:48:22  muir
 * rcsid now at top
 * 
 */

/*
 * trad.c
 *
 * buy units from other nations.
 *
 * Dave Pare, 1986
 */

#include <ctype.h>
#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "item.h"
#include "ship.h"
#include "nuke.h"
#include "plane.h"
#include "unit.h"
#include "trade.h"

/*
 * format: trade
 *
 */
trad() {
	extern	char *getstarg();
	extern	char *fmt();
	extern	float multread();
	extern	char *getstring();
	extern	struct trdstr trade;
	extern	char *argp[];
	extern	struct plchrstr plchr[];
	extern	int god;
	extern	int cnum;
	extern	int xorg, yorg;
	extern	struct natstr *natp;
	extern	int sx, sy;
	extern	struct uchrstr uchr[];
	extern	struct ichrstr ichr[];
	extern	struct vchrstr vchr[];
	extern	struct mchrstr mchr[];
	extern	double dolcost;
	extern	struct sctstr sect;
	extern	int owner;
	int	lotno;
	float	price;
	struct	ustr unit;
	struct	uchrstr *up;
	int	n;
	int	i;
	char	*p;
	int	saveid;

	pr("\n     Empire Trade Report\n  ");
	prdate();
	savnat(natp);
	commread();
	n = 0;
	pr(" lot# cnum   country   price              desc\n");
	for (i=0; gettrd(i) != -1; i++) {
		if (trade.trd_unitid < 0)
			continue;
		if (getunit(trade.trd_type, trade.trd_unitid, &unit) < 0 ||
		    trade.trd_owner != unit.u_gen.g_own) {
			trade.trd_unitid = -1;
			puttrd(i);
			continue;
		}
		pr(fmt(" %2d ", i));
		(void) trade_desc(&trade, &unit);
		if (trade.trd_owner == cnum && !god)
			pr(" (your own lot)\n");
		else
			pr("\n");
		n++;
	}
	rstnat();
	if (n == 0) {
		pr("Nothing to buy at the moment...\n");
		return RET_OK;
	}
	if ((p = getstring("Which lot to buy : ")) == 0 || *p == 0)
		return RET_OK;
	if (isdigit(*p) == 0)
		return RET_OK;
	lotno = atoi(p);
	if (lotno < 0 || lotno >= i) {
		pr("Bad lot number\n");
		return RET_OK;
	}
	sigsave();
	tradelock();
	if (gettrd(lotno) < 0) {
		pr("No such lot number\n");
		tradeunlock();
		sigrest();
		return RET_OK;
	}
	up = &uchr[trade.trd_type];
	if (getunit(trade.trd_type, trade.trd_unitid, &unit) == -1) {
		pr(fmt("Can't find %s #%d!\n", up->u_name, trade.trd_unitid));
		trade.trd_unitid = -1;
		puttrd(lotno);
		tradeunlock();
		sigrest();
		return RET_OK;
	}
	switch (up->u_type) {
	case U_NUKE:
		if (getsect(unit.u_nuke.nuk_x - xorg,
				unit.u_nuke.nuk_y - yorg) == -1) {
			tradeunlock();
			sigrest();
			return RET_FAIL;
		}
		trade.trd_owner = sect.sct_own;
		break;
	case U_PLANE:
	case U_TANK:
	case U_SHIP:
		break;
	default:
		tradeunlock();
		sigrest();
		pr(fmt("Bad unit type on lot number %d\n", lotno));
		return RET_FAIL;
	}
	if (trade.trd_owner == cnum) {
		tradeunlock();
		sigrest();
		pr("You can't buy from yourself!\n");
		return RET_FAIL;
	}
	price = multread(trade.trd_owner, cnum) * trade.trd_price;
	if (natp->nat_money < price) {
		tradeunlock();
		sigrest();
		pr(fmt("You don't have %.2f to spend!\n", price));
		return RET_OK;
	}

/*  Find the destination sector for the plane - before the trade
    is actually made. Must be owned (except for satellites) and
    must be a 60% airfield (except for VTOL planes) */

	if (trade.trd_type == U_PLANE) {
		int plflags = plchr[unit.u_plane.pln_type].pl_flags;

		while (1) {
			if (getsno(0, "destination sector : ") >= 0 &&
				(owner || (plflags & P_O))) break;
			pr("Try again...\n");
		}

		if (plflags & (P_V | P_O)) goto buy_label;

		if (!god && (sect.sct_type != SCT_AIRPT)) {
			tradeunlock();
			sigrest();
			pr("Destination sector is not an airfield!\n");
			return RET_OK;
		}
		if (!god && (sect.sct_effic < 60)) {
			tradeunlock();
			sigrest();
			pr("Sector under construction\n");
			return RET_OK;
		}
	}
buy_label:
	saveid = trade.trd_unitid;
	trade.trd_unitid = -1;
	puttrd(lotno);
	tradeunlock();
	pr(fmt("Bought %s %d for %.2f\n", up->u_name, saveid, price));
	switch (trade.trd_type) {
	case U_NUKE:
		while (1) {
			if (getsno(0, "destination sector : ") >= 0 && owner)
				break;
			pr("Try again...\n");
		}
		unit.u_nuke.nuk_x = sx;
		unit.u_nuke.nuk_y = sy;
		break;
	case U_PLANE:
		unit.u_plane.pln_x = sx;
		unit.u_plane.pln_y = sy;
		unit.u_plane.pln_own = cnum;
		/* no cheap version of fly */
		unit.u_plane.pln_mobil = 0;
		unit.u_plane.pln_ship = -1;
		/*
		 * make it so that the buyer has to work a bit to
		 * "train his crews" in the use of the plane
		 */
		if (unit.u_plane.pln_effic > 75)
			unit.u_plane.pln_effic = 75;
		break;
	case U_SHIP:
		unit.u_ship.shp_own = cnum;
		break;
	default:
		break;
	}
	putunit(saveid, &unit);
	NAT_DELTA(nat_money, trade.trd_owner, (int)(price * 0.95));
	nreport(trade.trd_owner, N_MAKE_SALE, cnum, 1);
	wu(0, trade.trd_owner, fmt("%s bought a %s #%d from you for $%.2f\n",
		cname(cnum), up->u_name, saveid, price * 0.95));
	dolcost += price;
	sigrest();
	return RET_OK;
}

trade_desc(tp, up)
	struct	trdstr *tp;
	struct	ustr *up;
{
	extern	struct nchrstr nchr[];
	int	i;
	float	price;

	price = multread(tp->trd_owner, cnum) * tp->trd_price;
	switch (up->u_type) {
	case U_NUKE: {
		struct nukstr *np = &up->u_nuke;
		if (getsect(np->nuk_x-xorg, np->nuk_y-yorg) < 0)
			return 0;
		getnat(tp->trd_owner = sect.sct_own);
		pr(fmt("(#%2d)  %8.8s  %10.2f   device %d",
			sect.sct_own, natp->nat_cnam, price, tp->trd_unitid));
		}
		break;
	case U_SHIP: {
		struct shpstr *sp = &up->u_ship;
		tp->trd_owner = sp->shp_own;
		pr(fmt("(#%2d)  %8.8s  %10.2f   tech %d %d%% %s [",
			tp->trd_owner, cname(tp->trd_owner),
			price,
			sp->shp_tech,
			sp->shp_effic,
			mchr[sp->shp_type].m_name));
		for (i=0; i<sp->shp_nv; i++) {
			pr(fmt("%c:%d ",
				ichr[sp->shp_vtype[i] & ~VT_TYPE].i_mnem,
				sp->shp_vamt[i]));
		}
		}
		pr(fmt("] %d", tp->trd_unitid));
		break;
	case U_PLANE: {
		struct plnstr *pp = &up->u_plane;

		tp->trd_owner = pp->pln_own;
		pr(fmt("(#%2d)  %8.8s  %10.2f   tech %d %d%% %s #%d",
			tp->trd_owner, cname(tp->trd_owner),
			price,
			pp->pln_tech,
			pp->pln_effic,
			plchr[pp->pln_type].pl_name,
			tp->trd_unitid));
		if (pp->pln_nuketype && pp->pln_nukeamt) {
			pr(fmt("(%dx%s)", pp->pln_nukeamt,
				nchr[pp->pln_nuketype].n_name));
		}
		}
		break;
	default:
		pr(fmt("flaky unit type %d", up->u_type));
		break;
	}
	return 1;
}
