static char *RCSid = "$Header: thre.c 1.7 89/03/17 $";

/*
 * thre.c
 *
 * describe threshold for given commodity in a sector
 * just like deliver...except this is used for distribution
 * sectors.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "nsc.h"

/*
 * threshold <COMM> <SECTS> <THRESH>
 */
thre()
{
	extern	struct ichrstr *whatitem();
	extern	char *fmt();
	extern	char *getstarg();
	extern	char *argp[];
	extern	struct sctstr sect;
	extern	int owner;
	extern	struct dchrstr dchr[];
	struct	nstr nstr;
	int	val;
	struct	ichrstr *ip;
	char	*p;
	int	thresh;
	int	type;

	if ((ip = whatitem(argp[1], "What commodity? ")) == 0)
		return RET_SYN;
	if (ip->i_vtype == V_CIVIL || ip->i_vtype == V_MILIT) {
		pr("You can't distribute people!\n");
		return RET_SYN;
	}
	if (snxtsct(&nstr, argp[2]) == -1)
		return RET_SYN;
	type = V_DIST(ip->i_vtype & ~VT_TYPE);
	if (argp[3] && *argp[3] && (*argp[3] < '0' || *argp[3] > '9')) {
		pr ("Threshold must be a number\n");
		return RET_SYN;
	}
	while (nxtsct(&nstr, 0)) {
		if (!owner)
			continue;
		val = gsctv(type);
		if (val > 0)
			p = fmt("%d,%d %s  old threshold %d new? ",
				nstr.n_x, nstr.n_y,
				dchr[sect.sct_type].d_name, val);
		else
			p = fmt ("%d,%d %s  threshold? ",
				 nstr.n_x, nstr.n_y,
				 dchr[sect.sct_type].d_name);
		if ((p = getstarg(argp[3], p)) == 0)
			continue;
		if (*p == '\0' || *p == '-')
			continue;
		thresh = atoi(p);
		if (val > 0 && (argp[3] != 0 && *argp[3] != 0))
			pr(fmt("%d,%d old threshold %d\n",
			       nstr.n_x, nstr.n_y, val));
		if( psctv(type, thresh) < 0)
			pr(fmt("No room for threshold in %d,%d\n",
			       nstr.n_x, nstr.n_y));
		putsect(nstr.n_x, nstr.n_y);
	}
	return 0;
}
