#ifndef lint
static char *RCSid = "$Header: terr.c 1.8 89/03/17 $";
#endif

/*
 * terr.c
 *
 * designate territory of sectors
 *
 * Edward M. Rynes Esq.
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nsc.h"
#include "item.h"

terr()
{
	extern char *fmt();
	extern char *getstarg();
	extern char *argp[];
	extern struct sctstr sect;
	extern struct dchrstr dchr[];
	extern int diroff[][2];
	extern int owner;
	char   *p;
	int     terr_n;
	struct nstr nstr;

	if (snxtsct(&nstr, argp[1]) < 0)
		return RET_SYN;
	while (nxtsct(&nstr, 0)) {
		if (!owner)
			continue;

		p = fmt("%d,%d %d%% %s  territory? ", nstr.n_x, nstr.n_y,
			sect.sct_effic, dchr[sect.sct_type].d_name);
		p = getstarg(argp[2], p);
		if (*p == 0)
			continue;

		terr_n = atoi(p);

		if (terr_n < 0 || terr_n > 99 || *p < '0' || *p > '9') {
			pr("Enter a number between 0 and 99!\n");
			continue;
		}
		getsect(nstr.n_x, nstr.n_y);
		sect.sct_terr = terr_n;
		putsect(nstr.n_x, nstr.n_y);
	}

	return RET_OK;
}
