#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/tele.c,v 1.8 89/05/10 01:58:21 muir Exp $";
#endif

/*
 * tele.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "tel.h"
#include "news.h"
#include "deity.h"
#include "file.h"

tele()
{
	extern	char *argp[];
	register int n;
	struct	natstr *natp;
	struct	natstr *np;
	int	teltype;
	char    buf[513];

	natp = getnatp(cnum);
	if (*argp[0] == 'a') {
		if (!god) {
			if (natp->nat_money <= 100) {
				pr("You don't have the $100\n");
				return RET_FAIL;
			}
		}
		NAT_DELTA(nat_money, cnum, -100);
		if (getele("everybody", buf) <= 0) {
			pr("Command ignored\n");
			return RET_SYN;
		}
		pr("\n");
		for (n=0; np = getnatp(n); n++) {
			if (n == cnum)
				continue;
			if ((np->nat_stat & STAT_NORM) == 0)
				continue;
			if (typed_wu(cnum, n, buf, TEL_ANNOUNCE))
				logerror("tele: typed_wu failed to #%d", n);
		}
	} else {
		if ((n = natarg(argp[1], "for which country? ")) < 0)
			return RET_SYN;
		natp = getnatp(n);
		if ((natp->nat_stat & STAT_NORM) == 0) {
			pr(fmt("%s has no \"telegram priveleges\".\n",
			       cname(n)));
			return RET_SYN;
		}
		if (getele(cname(n), buf) < 0) {
			pr("Command ignored\n");
			return RET_SYN;
		}
		pr("\n");
		teltype = god ? TEL_BULLETIN : TEL_NORM;
		if (typed_wu(cnum, n, buf, teltype) < 0) {
			logerror("tele: typed_wu failed to #%d", n);
			return RET_FAIL;
		}
		if (!god && (natp->nat_stat & GOD) != GOD)
			nreport(cnum, N_SENT_TEL, n, 1);
	}
	return RET_OK;
}
