#ifndef lint
static char *RCSid = "$Header: spy.c,v 1.8 89/05/09 15:29:48 muir Locked $";
#endif

/*
 * spy.c
 *
 * spy on your neighbors
 *
 * from PSL Empire, 1985
 * and Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "nat.h"
#include "nsc.h"
#include "nuke.h"
#include "news.h"


/*
 * format:  spy <SECTS>
 *
 */
static int nsects;

spy()
{
	extern char *fmt();
	int     check();		    /* routines to modify
					     * the "table" */
	int     insert();
	extern char *argp[];
	extern int nukf;
	extern int btused;
	extern int nbtu;
	extern int lx, ly, hx, hy;
	extern int maxnoc;
	extern int cnum;
	extern struct natstr *natp;
	extern struct sctstr sect;
	extern int diroff[][2];
	extern int god;
	extern int owner;
	extern char *malloc();
	int     caught;
	int     own;
	int     relat;
	int     x, y;
	int     nx, ny;
	int     military;
	int     savemil;
	int     btucost;
	int     i;
	struct nstr nstr;
	int    *table;			    /* sectors already */
	int	t_len = 0;		    /* "seen" */

	/*
	 * first arg should be the range of sectors
	 */
	if ((snxtsct(&nstr, argp[1])) < 0)
		return RET_SYN;
	nsects = abs((hx - lx) / 2) * abs(hy - ly);
	table = (int *) malloc((unsigned) (nsects + 1) * 6 * 2 * sizeof(int)); /* 6 sectors per spying sector, 2 coords per sector */

	btucost = (nsects / 40) + 1;
	if (nbtu < btucost) {
		pr("You don't have the BTU's for spying on that scale!\n");
		return RET_FAIL;
	}
	/*
	 * set up all the goodies we need later
	 */
	bzero(table, (nsects + 1) * 6 * 2 * sizeof(int));

	sigsave();
	pr("SPY report\n");
	prdate();
	pr(" sect  type own  eff  civ  mil  shl  gun  iron  pet  food\n");
	while (nxtsct(&nstr, 0) > 0) {
		if (!owner && !god)
			continue;
		if ((military = gsctv(V_MILIT)) == 0)
			continue;
		x = sect.sct_x;
		y = sect.sct_y;
		savemil = military;
		/*
		 * check the neighboring sectors.
		 */
		for (i = 1; i <= 6; i++) {
			if (military == 0)
				break;
			nx = x + diroff[i][0];
			ny = y + diroff[i][1];
			/*
			 * if we've already seen the
			 * sector, don't bother checking it
			 * out.
			 */
			if (check(table, &t_len, nx, ny)) {
				continue;
			}
			getsect(nx, ny);
			if (owner || (!gsctv(V_CIVIL) && !gsctv(V_MILIT))) {
				/*
				 * tell the table we've
				 * seen the sector
				 */
				insert(table, &t_len, nx, ny);
				continue;
			}
			/*
			 * roll 1d200 to see if the
			 * patrolling military get the spy.
			 * If the roll is less than the
			 * military in the sector, BANG!!
			 */
			caught = chance((double) gsctv(V_MILIT) / 200.0);
			own = sect.sct_own;
			/*
			 * get the nation status out of the
			 * two bits allotted each country
			 * for the relations
			 */
			relat = getrel(own, cnum);
			if (relat == NEUTRAL && caught) {
				/*
				 * neutral spy-ee
				 */
				pr(fmt("Spy deported from %d,%d\n", nx, ny));
				wu(0, own, fmt("%s (#%d) spy deported from %s",
					       cname(cnum), cnum, xytoa(nx, ny, own)));
				continue;
			} else if (relat == AT_WAR && caught) {
				/*
				 * at-war with spy-ee
				 */
				pr(fmt("BANG!! A spy was shot in %d,%d\n",
				       nx, ny));
				military--;
				wu(0, own, fmt("%s (#%d) spy caught in %s",
					       cname(cnum), cnum, xytoa(nx, ny, own)));
				nreport(cnum, N_SPY_SHOT, own, 1);
				continue;
			}
			insert(table, &t_len, nx, ny);
			spyline(&sect);
		}
		/*
		 * subtract any military if necessary from
		 * BANG!! (I like that a lot)
		 */
		if (savemil != military) {
			getsect(x, y);
			psctv(V_MILIT, military);
			putsect(x, y);
		}
	}
	sect.sct_nv = 0;
	btused += btucost;
	sigrest();
	free(table);
	return RET_OK;
}


/*
 * just a big printf.
 */
static
spyline(sp)
	struct sctstr *sp;
{
	extern struct dchrstr dchr[];
	char   *fmt();

	pr(fmt("%3d,%-3d  %c  %-2d  %3d  %4d  %3d  %3d  %3d  %3d  %3d  %4d\n",
	       xwrap(sp->sct_x), ywrap(sp->sct_y), dchr[sp->sct_type].d_mnem,
	       sp->sct_own, round(sp->sct_effic, 10),
	       round(gsctv(V_CIVIL), 10), round(gsctv(V_MILIT), 10),
	       round(gsctv(V_SHELL), 10), round(gsctv(V_GUN), 10),
	       round(gsctv(V_IRON), 10), round(gsctv(V_PETROL), 10),
	       round(gsctv(V_FOOD), 10)));
}


/*
 * insert a key into the table.
 */
static
insert(table, len, x, y)
	int    *table;
	int    *len;
	int     x;
	int     y;
{
	if (!check(table, len, x, y)) {
	   table[(*len)++] = x;
	   table[(*len)++] = y;
	   }
}
/*
 * see if a key is in the bitmask table
 */
static int
check(table, len, x, y)
	int    *table;
	int    *len;
	int     x;
	int     y;
{
	int     i;

	for (i = 0; i < *len; i += 2)
	   if (table[i] == x && table[i + 1] == y)
	      return 1;
	return 0;
}

static int
sctval(x, y)
	int     x, y;
{
	extern char *privname;
	extern int w_xsize, w_ysize;
	int     res;
	int     nx, ny;

	nx = (xwrap(x - lx) + w_xsize / 2) / 2;
	ny = ywrap(y - ly) + w_ysize / 2;

	res = nx + abs(hx - lx) / 2 * ny;
	if (res > nsects || res < 0) {	    /* paranoia */
		erlog(fmt("bad sctval routine x=%d y=%d nx=%d ny=%d lx=%d hx=%d res=%d nsect=%d",
			  x, y, nx, ny, lx, hx, res, nsects));
		pr(fmt("Double agents!; tell %s\n", privname));
		return 0;
	}
	return res;
}
