#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/set.c,v 1.7 89/03/07 16:49:47 muir Exp $";
#endif

/*
 * set.c
 *
 * Place units on-sale.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "nuke.h"
#include "plane.h"
#include "unit.h"
#include "trade.h"

/*
 * format: set <type> <SHIP/NUKE> <PRICE>
 */

set()
{
	extern char *getstarg();
	extern char *fmt();
	extern struct uchrstr *typeunit();
	extern double atof();
	extern char *argp[];
	extern struct sctstr sect;
	extern struct trdstr trade;
	extern int xorg, yorg;
	extern int cnum;
	extern int god;
	struct uchrstr *up;
	struct ustr unit;
	int     i;
	char   *p;
	int     lotno;
	int     unitid;
	float   price;

	if ((p = getstarg(argp[1], "Unit type? ")) == 0 || *p == 0)
		return RET_OK;
	if ((up = typeunit(p)) == 0) {
		pr(fmt("No such unit %s\n", p));
		return RET_OK;
	}
	if ((p = getstarg(argp[2], fmt("%s to sell? ", up->u_name))) == 0) {
		return RET_OK;
	}
	unitid = atoi(p);
	if ((p = getstarg(argp[3], "price :  ")) == 0)
		return RET_OK;
	if ((price = atof(p)) < 0) {
		pr("No Crazy Eddie!\n");
		return RET_OK;
	}
	if (getunit(up->u_type, unitid, &unit) == -1) {
not_own:
		pr(fmt("You don't own that %s!\n", up->u_name));
		return RET_OK;
	}
	switch (up->u_type) {
	case U_NUKE:
		getsect(unit.u_nuke.nuk_x - xorg, unit.u_nuke.nuk_y - yorg);
		if (sect.sct_own != cnum && !god)
			goto not_own;
		trade.trd_owner = sect.sct_own;
		break;
	case U_SHIP:
	case U_PLANE:
		if (unit.u_gen.g_own != cnum && !god)
			goto not_own;
		trade.trd_owner = unit.u_gen.g_own;
		break;
	default:
		pr("Flaky unit type in up->u_unit\n");
		goto not_own;
	}
	sigsave();
	tradelock();
	lotno = -1;
	for (i = 0; gettrd(i) != -1; i++) {
		if (lotno < 0 && trade.trd_unitid == -1)
			lotno = i;
		if (trade.trd_type == up->u_type &&
		    trade.trd_unitid == unitid) {
			if (price == 0.0) {
				trade.trd_unitid = -1;
				pr(fmt("%s %d removed from trading\n",
				       up->u_name, unitid));
			} else
				trade.trd_price = price;
			puttrd(i);
			tradeunlock();
			sigrest();
			return RET_OK;
		}
	}
	if (lotno < 0)
		lotno = i;
	trade.trd_type = up->u_type;
	trade.trd_unitid = unitid;
	trade.trd_price = price;
	trade.trd_owner = cnum;
	puttrd(lotno);
	tradeunlock();
	sigrest();
	return RET_OK;
}
