#ifndef lint
static char *RCSid = "$Header: repo.c 1.12 89/03/17 $";
#endif

/*
 * repo.c
 *
 * report of comparative tech levels for the various
 * nations based on current nation's tech levels
 *
 * Keith Muller, 1983
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"

repo()
{
	extern char *fmt();
	extern char *argp[];
	extern struct natstr *natp;
	extern struct sctstr sect;
	extern int god;
	extern int maxnoc;
	extern int cnum;
	extern int xorg, yorg;
	register int i;
	register int j;
	float   myres;
	float   mytec;
	float   myedu;
	char    mystat;

	myres = natp->nat_level[NAT_RLEV];
	mytec = natp->nat_level[NAT_TLEV];
	myedu = natp->nat_level[NAT_ELEV];
	mystat = natp->nat_stat;
	if ((mystat & STAT_NORM) == 0) {
		myres = -301.0;
		mytec = -301.0;
		myedu = -301.0;
	}
	pr(" #    name             tech     research    education ");
	if (god)
		pr("happiness cap-location\n");
	else
		pr("   status\n");
	savnat(natp);
	for (i = 0; i < maxnoc; i++) {
		if (getnat(i) == 0)
			break;
		if ((natp->nat_stat & STAT_INUSE) == 0)
			continue;
		if (i == cnum && !god)
			continue;
		pr(fmt(" %-2d   %-14.14s ", i, natp->nat_cnam));
		if (god) {
			pr(fmt(" %7.2f   %7.2f     %7.2f    %7.2f  %3d,%3d\n",
			       natp->nat_level[NAT_TLEV],
			       natp->nat_level[NAT_RLEV],
			       natp->nat_level[NAT_ELEV],
			       natp->nat_level[NAT_HLEV],
			       xwrap(natp->nat_xcap - xorg),
			       ywrap(natp->nat_ycap - yorg)));
		} else switch(natp->nat_stat & (STAT_NORM|STAT_GOD|STAT_NEW)) {

		case NAT_NORM:
			printdiff(mytec, natp->nat_level[NAT_TLEV]);
			printdiff(myres, natp->nat_level[NAT_RLEV]);
			printdiff(myedu, natp->nat_level[NAT_ELEV]);
			j = getsect(capxof(i), capyof(i));
			if (j == -1 || sect.sct_own != i ||
			    (sect.sct_type != SCT_CAPIT &&
			     sect.sct_type != SCT_SANCT))
				pr("In flux\n");
			else if (natp->nat_money <= 0)
				pr("Broke\n");
			else if (sect.sct_type == SCT_SANCT)
				pr("Protected\n");
			else
				pr("Active\n");
			break;
		case 0:
		case NAT_NEW:
			pr("none        none        none        New\n");
			break;
		case NAT_NORM|NAT_GOD:
			pr("superior    superior    superior    DEITY\n");
			break;
		default:
			pr("????        ????        ????        ????\n");
			break;
		}
	}
	rstnat();
}
printdiff(ours, theirs)
	float   ours;
	float   theirs;
{
	float   ratio;
	char   *bp;
	float   diff;

	ratio = (ours + 1.0) / (theirs + 1.0);
	diff = ours - theirs;
	if (ratio < 0.10 || diff < -300.0)
		bp = "superior    ";
	else if (ratio < 0.50 || diff < -50.0)
		bp = "advanced    ";
	else if (ratio < 2.0)
		bp = "similar     ";
	else if (ratio < 10.00 || diff < 50)
		bp = "backward    ";
	else
		bp = "primitive   ";
	pr(bp);
}
