#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/real.c,v 1.8 89/05/10 01:58:07 muir Exp $";
#endif

/*
 * real.c
 *
 * show or set realm
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "xy.h"
#include "file.h"
#include "nsc.h"

real()
{
	extern	char *argp[];
	register struct boundstr *rp;
	struct	natstr *natp;
	int     curr;
	int     lastr;
	struct	range range;

	natp = getnatp(cnum);
	if (argp[1] == 0) {
		curr = 0;
		lastr = MAXNOR - 1;
	} else {
		curr = lastr = atoi(argp[1]);
		if (curr < 0 || curr >= MAXNOR) {
			pr(fmt("Realm number must be in the range 0:%d",
			       MAXNOR-1));
			return RET_SYN;
		}
	}
	if (argp[2] == 0) {
		while (curr <= lastr) {
			rp = &natp->nat_b[curr];
			pr(fmt("Realm #%d is %d:%d,%d:%d\n", curr, rp->b_xl,
			       rp->b_xh, rp->b_yl, rp->b_yh));
			curr++;
		}
	} else {
		if (sarg_type(argp[2]) != NS_AREA)
			return RET_SYN;
		if (!sarg_area(argp[2], &range))
			return RET_SYN;
		rp = &natp->nat_b[curr];
		rp->b_xl = range.lx;
		rp->b_xh = range.hx - range.ix;
		rp->b_yl = range.ly;
		rp->b_yh = range.hy - range.iy;
		if (rp->b_xl > rp->b_xh || rp->b_yl > rp->b_yh)
			pr("WARNING: high end of realm specified first!\n");
		NAT_SETARY(nat_b[0], cnum, curr, &natp->nat_b[curr]);
	}
	return RET_OK;
}
