#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/rea.c,v 1.10 89/05/10 01:58:04 muir Exp $";
#endif

/*
 * rea.c
 *
 * read from telegram file
 * modified to use stdio -- no sense in having
 * too many syscalls
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "tel.h"
#include "deity.h"

#include <stdio.h>
#include <sys/file.h>

rea()
{
	extern char *argp[];
	extern	char *telnames[];
	register char *p;
	register char *mbox;
	struct	telstr tgm;
	FILE   *telfp;
	int     teles;
	int     size;
	int     nbytes;
	char    buf[513];
	int     num;
	int     lasttype;
	int     lastcnum;
	time_t  lastdate;
	int     header;

	if (god && argp[1] != 0) {
		if ((num = natarg(argp[1], "")) < 0)
			return RET_SYN;
	} else
		num = cnum;
	mbox = mailbox(num);
	if ((telfp = fopen(mbox, "r+")) == 0) {
		logerror("telegram file %s", mbox);
		return RET_FAIL;
	}
	teles = 0;
	size = fsize(fileno(telfp));
more:
	lastdate = 0;
	lastcnum = -1;
	lasttype = -1;
	while (fread((char *) &tgm, sizeof(tgm), 1, telfp) == 1) {
		if (tgm.tel_length < 0) {
			logerror("bad telegram file header in %s", mbox);
			break;
		}
		header = 0;
		if ((tgm.tel_from && (tgm.tel_type != lasttype)) ||
		   tgm.tel_from != lastcnum)
			header++;
		if (abs(tgm.tel_date - lastdate) > 60)
			header++;
		if (header) {
			pr("> ");
			lastcnum = tgm.tel_from;
			lasttype = tgm.tel_type;
			if (tgm.tel_from) {
				pr(fmt("%s from %s, (#%d)",
				       telnames[tgm.tel_type],
				       cname(tgm.tel_from),
				       tgm.tel_from));
			} else {
				pr("BULLETIN!     ");
			}
			pr(fmt("  dated %s", ctime(&tgm.tel_date)));
			lastdate = tgm.tel_date;
		}
		while (tgm.tel_length > 0) {
			nbytes = tgm.tel_length;
			if (nbytes > 512)
				nbytes = 512;
			(void) fread(buf, sizeof(char), nbytes, telfp);
			buf[nbytes] = 0;
			pr(buf);
			tgm.tel_length -= nbytes;
		}
		pr("\n");
		teles++;
	}
	if (teles > 0 && cnum == num) {
		if (teles == 1) {
			if (chance(0.25))
				p = "Forget this one? ";
			else
				p = "Shall I burn it? ";
		} else {
			if (chance(0.25))
				p = "Into the shredder, boss? ";
			else
				p = "Can I throw away these old love letters? ";
		}
		p = getstring(p);
		if (*p == 'y') {
			if ((num = fsize(fileno(telfp))) > size) {
				pr("Wait a sec!  A new telegram has arrived...\n");
				/*
				 * makes it so fread will
				 * re-read the data
				 */
				(void) fseek(telfp, (long) size, L_SET);
				size = num;
				goto more;
			}
			(void) unlink(mbox);
			(void) close(creat(mbox, 0660));
		}
	}
	if (teles <= 0) {
		if (cnum == num)
			pr("No telegrams for you at the moment...\n");
		else
			pr(fmt("No telegrams for %s at the moment...\n",
			       cname(num)));
	}
	(void) fclose(telfp);
	return RET_OK;
}
