#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/plan.c,v 1.5 89/03/07 16:49:22 muir Exp $";
#endif

/*
 * plan.c
 *
 * Do a "plane report" (like ships report)
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "plane.h"
#include "nsc.h"
#include "nuke.h"

plan()
{
	extern char *fmt();
	char   *splur();
	extern double techfact();
	extern struct plchrstr plchr[];
	extern char *argp[];
	extern struct nchrstr nchr[];
	extern int cnum;
	extern int god;
	register int nplanes;
	register struct plnstr *pp;
	struct npstr np;
	struct plnstr p;

	if (snxtpln(&np, argp[1], god ? 0 : cnum, "") + 1 == 0)
		return 2;
	nplanes = 0;
	pp = &p;
	while (nxtpln(&np, pp)) {
		if (nplanes++ == 0)
			pr("   #    type          x,y  wing eff  mu att def tech ran ship nuke\n");
		pr(fmt("%4d ", np.np_sno));
		pr(fmt("%-14.14s ", plchr[pp->pln_type].pl_name));
		pr(fmt("%3d,%-3d ", pp->pln_x, pp->pln_y));
		pr(fmt(" %c ", pp->pln_wing));
		pr(fmt("%3d%%", pp->pln_effic));
		pr(fmt("%4d", pp->pln_mobil));
		pr(fmt("%4d", pp->pln_att));
		pr(fmt("%4d", pp->pln_def));
		pr(fmt("%4d", pp->pln_tech));
		pr(fmt("%4d", pp->pln_range));
		if (pp->pln_ship >= 0)
			pr(fmt("%4d", pp->pln_ship));
		else
			pr("     ");
		if (pp->pln_nukeamt > 0)
			pr(fmt(" %1d %10.10s\n", pp->pln_nukeamt,
			       nchr[pp->pln_nuketype].n_name));
		else
			pr("\n");
	}
	if (nplanes == 0) {
		pr(fmt("%s: No plane(s)\n", (argp[1] == 0) ? "" : argp[1]));
		return RET_FAIL;
	}
	pr(fmt("%d plane%s\n", nplanes, splur(nplanes)));
	return RET_OK;
}
