#ifndef lint
static char *RCSid = "$Header: orig.c 1.7 89/03/17 $";
#endif

/*
 * orig.c
 *
 * move your origin
 *
 * Shelley Louie, 1988
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "nsc.h"
#include "item.h"

orig()
{
	extern char *fmt();
	extern char *argp[];
	extern struct sctstr sect;
	extern int xorg, yorg;
	extern struct natstr *natp;
	extern int cnum;
	extern int nstat;
	register int r11;

	if (getsno(argp[1], "New origin location : ") < 0) {
		return RET_SYN;
	}
	if (((sect.sct_x + sect.sct_y) & 0x01) != 0) {
		pr("That's not a real sector!\n");
		return RET_FAIL;
	}
	getnat(cnum);
	xorg = natp->nat_xorg = xwrap(natp->nat_xorg + sect.sct_x);
	yorg = natp->nat_yorg = ywrap(natp->nat_yorg + sect.sct_y);
	offset(xorg, yorg);
	NAT_SET(nat_xorg, cnum, xorg);
	NAT_SET(nat_yorg, cnum, yorg);
	for (r11 = MAXNOR - 1; r11 >= 0; r11--) {
		natp->nat_b[r11].b_xl -= sect.sct_x;
		natp->nat_b[r11].b_xh -= sect.sct_x;
		natp->nat_b[r11].b_yl -= sect.sct_y;
		natp->nat_b[r11].b_yh -= sect.sct_y;
		/*
		 * * pass pointer to struct for portability
		 */
		NAT_SETARY(nat_b[0], cnum, r11, &natp->nat_b[r11]);
	}
	pr("Designation of new origin requires revision of sector numbers.\n");
	pr(fmt("Origin at %d,%d (old system) is now at 0,0 (new system).\n",
	       xwrap(sect.sct_x), ywrap(sect.sct_y)));
#ifdef	DEBUG_ORIGIN
	pr(fmt("[xy]org = %d,%d\n", natp->nat_xorg, natp->nat_yorg));
#endif
	return RET_OK;
}
