#ifndef lint
static char *RCSid = "$Header: navi.c 1.11 89/03/17 $";
#endif

/*
 * navi.c
 *
 * navigate ships and such.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "ship.h"
#include "sect.h"
#include "news.h"
#include "nsc.h"
#include "nat.h"

static void ship_mess();
static int check_nav();
 /* return codes from check_nav */
#define CN_LANDLOCKED	(1)
#define CN_CONSTRUCTION	(2)
#define CN_ERROR		(-1)
#define CN_NAVIGABLE	(0)

navi()
{
	extern char *getstring();
	extern char *fmt();
	extern double techfact();
	extern char *argp[];
	extern int cnum;
	extern struct mchrstr mchr[];
	extern struct dchrstr dchr[];
	extern struct sctstr sect;
	extern int diroff[][2];
	extern int god;
	extern char dirch[];
	extern int owner;
	register n;
	register m;
	char   *cp;
	int     dir;
	int     nships;
	int     newx;
	int     newy;
	int     dx;
	int     dy;
	int     stopping;
	int     viewing;
	int     snums[NBLISTMAX];
	int     mines;
	int     shells;
	int     barom;
	int     flagship;
	double  mobcost;
	double  mobils[NBLISTMAX];
	double  minmob;
	struct nbstr blist;
	struct shpstr ships[NBLISTMAX];
	struct shpstr *shpq;
	struct shpstr *shpp;
	struct mchrstr *mcp;

	if (snxtshp(&blist, argp[1], cnum, "Ship(s)? ") == -1)
		return RET_SYN;
	minmob = 9999.0;
	flagship = -1;
	for (n = 0; n < NBLISTMAX && nxtshp(&blist, &ships[n]);) {
		snums[n] = blist.nb_sno;
		if (flagship == -1)
			flagship = blist.nb_sno;
		shpp = &ships[n];
		mobils[n] = (double) shpp->shp_mobil;
		if (mobils[n] <= 0.0) {
			ship_mess("out of mobility", snums[n], shpp);
			continue;
		} else if (mobils[n] < minmob)
			minmob = mobils[n];

		/* check crew - uws don't count */
		if (gshpv(V_MILIT, shpp) < 1 && gshpv(V_CIVIL, shpp) < 1) {
			ship_mess("crewless", snums[n], shpp);
			continue;
		}
		switch (check_nav(shpp->shp_x, shpp->shp_y)) {
		case CN_CONSTRUCTION:
			ship_mess("caught in a construction zone", snums[n],
				  shpp);
			continue;
		case CN_LANDLOCKED:
			ship_mess("landlocked", snums[n], shpp);
			continue;
		default:
		case CN_ERROR:
			ship_mess("subject to an empire error", snums[n],
				  shpp);
			continue;
		case CN_NAVIGABLE:
			break;
		}

		if ((barom = wethr(shpp->shp_x, shpp->shp_y, (long) 0)) < 745) {
			for (shpq = ships; shpq < shpp; shpq++)
				if (shpq->shp_x == shpp->shp_x &&
				    shpq->shp_y == shpp->shp_y)
					break;
			if (shpq >= shpp)
				pr(fmt("Barometer @%d in %d, %d\n",
				       barom, shpp->shp_x, shpp->shp_y));
		}
		n++;			    /* good ship - keep it */
	}
	if (n == 0) {
		pr("No ships\n");
		return RET_SYN;
	}
	if (flagship != snums[0]) {
		pr(fmt("Flagship #%d is not sea worthy\n", flagship));
		return RET_SYN;
	}
	nships = n;
	shpq = ships;
	stopping = 0;
	cp = argp[2];

	sigsave();
	for (;;) {
		dx = dy = viewing = 0;
		if (cp == 0 || *cp == 0)
			cp = getstring(fmt("<%.1f:%.1f: %d, %d> ", mobils[0], minmob,
					   shpq->shp_x, shpq->shp_y));
		if (cp == 0 || *cp == 0)
			cp = &dirch[DIR_STOP];
		if (*cp == 'r' || *cp == 'l') {
			argp[1] = ++cp;
			for (n = 0; n < nships; n++)
				if (snums[n] != -1)
					putship(snums[n], &ships[n]);
			if (cp[-1] == 'r')
				rada();
			else
				look();
			cp = 0;
			continue;
		} else {
			dir = chkdir(*cp++, DIR_STOP, DIR_VIEW);
			if (dir == -1) {
				pr(fmt("\"%c\" is not legal...", cp[-1]));
				direrr("`%c' to stop", " & `%c' to view\n", 0);
				cp = "";
				continue;
			}
			if (dir == DIR_VIEW)
				viewing++;
			else if (dir == DIR_STOP)
				stopping++;
			else {
				dx = diroff[dir][0];
				dy = diroff[dir][1];
			}
		}
		minmob = 9999.0;
		for (n = 0; n < nships; n++) {
			if (snums[n] == -1)
				continue;
			shpp = &ships[n];
			mcp = &mchr[shpp->shp_type];
			newx = xwrap(shpp->shp_x + dx);
			newy = ywrap(shpp->shp_y + dy);
			barom = min(wethr(newx, newy, (long) 0) - 330, 430);
			if (viewing || stopping || god)
				mobcost = 0.0;
			else {
				mobcost = shpp->shp_effic * 0.01 * mcp->m_speed;
				mobcost = 480.0 /
				    (mobcost + techfact(shpp->shp_tech, mobcost));
				mobcost *= 430.0 / barom;
			}
			if (check_nav(newx, newy) != CN_NAVIGABLE ||
			    (sect.sct_own && !owner &&
			     getrel(sect.sct_own, cnum) != ALLIED)) {
				pr(fmt("%s #%d can't go to %d,%d\n",
				       mcp->m_name, snums[n], newx, newy));
				cp = 0;
				if (mobils[n] < minmob)
					minmob = mobils[n];
				continue;
			}
			if (viewing) {
				if (mcp->m_flags & M_FOOD)
					pr(fmt("[fert:%d] ", sect.sct_fertil));
				if (mcp->m_flags & M_OIL)
					pr(fmt("[oil:%d] ", sect.sct_oil));
				pr(fmt("%s #%d @ %d,%d %d%% %s\n", mcp->m_name,
				       snums[n], newx, newy, sect.sct_effic,
				       dchr[sect.sct_type].d_name));
			}
			shpp->shp_x = newx;
			shpp->shp_y = newy;
			mobils[n] -= mobcost;
			if (mobils[n] <= 0.0 || stopping) {
				pr(fmt("%s #%d stopped at %d,%d\n", mcp->m_name,
				       snums[n], shpp->shp_x, shpp->shp_y));
				shpp->shp_mobil = mobils[n];
				putship(snums[n], shpp);
				snums[n] = -1;
				continue;
			}
			if (mobils[n] < minmob)
				minmob = mobils[n];
			if (viewing)
				continue;
			mines = gsctv(V_MINE);
			if ((mcp->m_flags & M_SWEEP) && mines > 0 && !owner) {
				shells = gshpv(V_SHELL, shpp);
				m = 0;
				do {
					if (mines > 0 && chance(0.66)) {
						pr("Sweep...\n");
						mines--;
						shells = min(getvar(V_SHELL, mcp,
								    GT_MCHR), shells + 1);
					}
				} while (++m < 5);
				psctv(V_MINE, mines);
				putsect(newx, newy);
				pshpv(V_SHELL, shells, shpp);
			}
			if (mines > 0 && !owner && chance(0.05 * mines)) {
				pr(fmt("\007Kawhomp! Mine detected by %s #%d in %d,%d!\n",
				       mcp->m_name, snums[n], newx, newy));
				nreport(cnum, N_HIT_MINE, 0, 1);
				if (mcp->m_frnge)
					m = 15 + 1350 / mcp->m_armor;
				else
					m = 2100 / (mcp->m_vrnge * mcp->m_visib);
				shipdamage(shpp, m + rand() % 21);
				mines--;
				psctv(V_MINE, mines);
				putsect(newx, newy);
				cp = 0;
				pr(fmt("%d%% damage sustained\n", m));
			}
			if (barom < 400 && rand() % 450 > barom) {
				m = 450 - barom;
				m = 10 + (rand() % m) / 5;
				pr(fmt("%s #%d in %d,%d reports %d%% storm damage!\n",
				       mcp->m_name, snums[n], newx, newy, m));
				shipdamage(shpp, m);
				nreport(cnum, N_SHP_STORM, 0, 1);
				cp = 0;
			}
		}
		if (stopping)
			return RET_OK;
		if (snums[0] == -1)	    /* flagship stops - all
					     * stop */
			cp = &dirch[DIR_STOP];
	}
}

static void 
ship_mess(str, n, shp)
	char   *str;
	int     n;
	struct shpstr *shp;
{
	extern struct mchrstr mchr[];

	pr(fmt("%s #%d is %s & stays in %d,%d\n",
	       mchr[shp->shp_type].m_name, n,
	       str, shp->shp_x, shp->shp_y));
}

static int 
check_nav(x, y)
	int     x, y;
{
	extern struct dchrstr dchr[];

	if (getsect(x, y) < 0)
		return CN_ERROR;
	switch (dchr[sect.sct_type].d_flg & 03) {
	case NAVOK:
		break;

	case NAV_02:
		if (sect.sct_effic < 2)
			return CN_CONSTRUCTION;
		break;
	case NAV_60:
		if (sect.sct_effic < 60)
			return CN_CONSTRUCTION;
		break;
	default:
		return CN_LANDLOCKED;
	}
	return CN_NAVIGABLE;
}
