static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/nati.c,v 1.8 89/05/10 01:57:28 muir Exp $";

/*
 * nati.c
 *
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "nat.h"
#include "sect.h"
#include "file.h"
#include "xy.h"

int
nati()
{
	extern	char *argp[];
	register int i;
	struct	natstr *natp;
	struct	natstr *np;
	struct	sctstr sect;
	int	mil;
	int	civ;

	if ((natp = getnatp(cnum)) == 0) {
		pr(fmt("Bad country number %d\n", cnum));
		return RET_SYN;
	}
	pr(fmt("\t%s Nation Report\t", cname(cnum)));
	prdate();
	pr(fmt("Nation status is %s", natstate(natp)));
	pr(fmt("     Bureaucratic Time Units: %d\n", natp->nat_btu));
	if (natp->nat_stat & STAT_INUSE) {
		getsect(natp->nat_xcap - natp->nat_xorg,
			natp->nat_ycap - natp->nat_yorg, &sect);
		if (!owner || (sect.sct_type != SCT_CAPIT &&
		    sect.sct_type != SCT_SANCT))
			pr(fmt("No capital. (was at %s)\n", ownxy(&sect)));
		else {
			civ = getvar(V_CIVIL, &sect, EF_SECTOR);
			mil = getvar(V_MILIT, &sect, EF_SECTOR);
			pr(fmt("%d%% eff capital at %s has %d civilian%s & %d military\n",
			       sect.sct_effic, ownxy(&sect), civ,
			       splur(civ), mil));
		}
	}
	for (i = 0; i < MAXNOR; i++)
		pr(fmt("#%d  %d:%d,%d:%d%s", i, natp->nat_b[i].b_xl,
		       natp->nat_b[i].b_xh, natp->nat_b[i].b_yl,
		       natp->nat_b[i].b_yh, (i & 0x3) != 3 ? "    " : "\n"));
	pr(fmt(" The treasury has $%.2f", (double) natp->nat_money));
	pr(fmt("     Military reserves: %d\n", natp->nat_reserve));
	pr(fmt("Education..........%6.2f       Happiness.......%6.2f\n",
		(double) natp->nat_level[NAT_ELEV],
		(double) natp->nat_level[NAT_HLEV]));
	pr(fmt("Technology.........%6.2f       Research........%6.2f\n",
		(double) natp->nat_level[NAT_TLEV],
		(double) natp->nat_level[NAT_RLEV]));
	pr(fmt("Technology factor :%6.2f%%", tfact(cnum, 100.)));
	pr(fmt("      Plague factor : %6.2f%%\n",
	       ((double) natp->nat_level[NAT_TLEV] + 100.) /
	       ((double) natp->nat_level[NAT_RLEV] + 100.)));
	pr("\n  Formal Relations         yours     theirs\n");
	for (i=0; np = getnatp(i); i++) {
		if (i == cnum || (np->nat_stat & STAT_INUSE) == 0)
			continue;
		pr(fmt("%3d) %-20.20s  ", i, cname(i)));
		pr(fmt("%s %s\n", relatename(natp, i), relatename(np, cnum)));
	}
	return RET_OK;
}
