#ifndef lint
static char *RCSid = "$Header: mult.c 1.7 89/03/17 $";
#endif

/*
 * mult.c
 *
 * Set per-nation list of price multipliers.  This should go in the
 * nation structure I think...
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "nat.h"

/*
 * format: mult
 *
 */
mult()
{
	extern double atof();
	extern char *argp[];
	extern int cnum;
	extern struct natstr *natp;
	int     i;

	savnat(natp);
	commread();
	i = natarg(argp[1], "for which country? ");
	if (i >= 0)
		getnat(i);
	if ((i < 0) || ((natp->nat_stat & STAT_INUSE) == 0) {
		pr("Editing nation price multipliers...\n");
		for (i = 0; getnat(i) != 0; i++) {
			if ((natp->nat_stat & STAT_NORM) == 0)
				continue;
			multsingle(cnum, i);
		}
	} else {
		if ((natp->nat_stat & STAT_NORM) == 0) {
			pr(fmt("%s has no \"market priveleges\".\n",
			       cname(i)));
			return RET_SYN;
		}
		multsingle(cnum, i);
	}
	rstnat();
	return RET_OK;
}

multsingle(countryn, i)
	int     countryn, i;
{
	extern char *fmt();
	extern char *getstarg();
	extern float multread();
	extern double atof();
	extern char *argp[];
	extern struct natstr *natp;
	extern double minmult;
	float   price;
	char   *p;

	p = getstarg(argp[2], fmt("%s (%7.3f) : ",
				  natp->nat_cnam, multread(countryn, i)));
	if (p == 0 || *p == 0)
		return;
	if ((price = atof(p)) == 0.0)
		return;
	/*
	 * no free lunches!
	 */
	if (price <= minmult)
		price = minmult;
	sigsave();
	commlock();
	commread();
	multset(i, price);
	commwrite();
	communlock();
	sigrest();
}
