static char *RCSid = "$Header: mine.c,v 1.4 89/02/11 15:58:27 muir Locked $";

/*
 * $Log:	mine.c,v $
 * Revision 1.4  89/02/11  15:58:27  muir
 * after mr-frog changes
 * 
 * Revision 1.3  88/04/01  04:40:32  muir
 * rcsid now at top
 * 
 */

/*
 * mine.c
 *
 * lay mines from ships
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "ship.h"
#include "sect.h"

mine()
{
	extern	char *fmt();
	extern	char *argp[];
	extern	struct mchrstr mchr[];
	extern	struct shpstr ship;
	extern	struct sctstr sect;
	extern	int cnum;
	extern	int god;
	register int r11;
	register int r10;
	struct	mchrstr *mp;
	int	f4;

	if ((r10 = getshno(argp[1], "from ship? ", &ship)) < 0) {
		pr("Usage: mine (ship)\n");
		return 2;
	}
	mp = &mchr[ship.shp_type];
	if (ship.shp_own != cnum && !god) {
		pr("Not your ship\n");
		return 2;
	}
	if ((mp->m_flags & M_MINE) == 0) {
		pr(fmt("You can't lay mines from a %s!\n",
			mp->m_name));
		return 1;
	}
	if ((f4 = gshpv(V_SHELL, &ship)) == 0) {
		pr(fmt("No mines on %s #%d\n", mp->m_name, r10));
		return 1;
	}
	if (getsect(ship.shp_x, ship.shp_y) < 0 ||
	    (sect.sct_type != SCT_WATER && sect.sct_type != SCT_BSPAN)) {
		pr("You can't lay mines there!!\n");
		return 1;
	}
	r11 = onearg(argp[2], fmt("Drop how many mines? <max %d> ", f4));
	r11 = min(f4, r11);
	pshpv(V_SHELL, f4 - r11, &ship);
	psctv(V_MINE, r11);
	while (r11-- > 0) {
		pr("Splash...  ");
		if ((r11 % 8) == 0)
			pr("\n");
	}
	pr("\n");
	putsect(ship.shp_x, ship.shp_y);
	putship(r10, &ship);
	return 0;
}
