static char *RCSid = "$Header: mark.c,v 1.5 89/02/11 15:58:26 muir Locked $";

/*
 * $Log:	mark.c,v $
 * Revision 1.5  89/02/11  15:58:26  muir
 * after mr-frog changes
 * 
 * Revision 1.4  88/12/12  02:41:05  muir
 * Tom Tedrick changed market to show, in case of ties for
 * best price, the greatest quantity of a product available.
 * Date = December 12, 1988.
 * (In case of ties for both quantity and best price, lowest
 * country number appears.)
 * 
 * Revision 1.3  88/04/01  04:40:17  muir
 * rcsid now at top
 * 
 */

/*
 * mark.c
 *
 * World market report for commodities.
 * displays only the "best prices" for all the
 * commodities available for trading.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "nsc.h"
#include "item.h"

mark()
{
	extern	char *fmt();
	extern	struct ichrstr ichr[];
	extern	char *argp[];
	extern	int cnum;
	extern	int god;
	extern	int maxnoc;
	struct	ichrstr *ip;
	extern	struct ichrstr *whatitem();
	int	product;
	int	number;
	float	bestprice;
	float	price;
	int	maxamt;
	int	amt;
	int	n;
	int	i;

	commread();
	if (argp[1] && *argp[1]) {
		ip = whatitem (argp[1], "Commodity : ");
		if (ip == 0)
			return RET_OK;
		if (ip -> i_sell == 0) {
			pr (fmt("%s cannot be traded!\n", ip->i_name));
			return RET_OK;
		}
		product = ip->i_vtype & ~VT_TYPE;
		number = 0;
		for (i=0; i<maxnoc; i++) {
			if ((amt = commamt(i, product, &price)) == 0)
				continue;
			if (number == 0) {
				pr(fmt("Trade report : %s\n", ip->i_name));
				pr(" cnum      country   amount  item price\n");
			}
			pr(fmt("(#%2d) %12.12s %7d %7.2f", i, cname(i),
			       amt, price));
			if (i == cnum && !god)
				pr(" (your own lot)\n");
			else
				pr("\n");
			number++;
		}
		if (number == 0) {
			pr(fmt("No countries are selling %s\n", ip->i_name));
			return RET_OK;
		}
		return RET_OK;
	}
	pr("      -= World Commodity Market Report =-\n");
	pr("             -= Todays Best Buys =-\n");
	pr("            ");
	prdate();
	pr(" item        cnum      country    qty     $/unit\n");
	for (ip = &ichr[1]; ip->i_name != 0; ip++) {
		if (ip->i_sell == 0)
			continue;
		number = -1;
		product = ip->i_vtype & ~VT_TYPE;
		bestprice = 99999999.0;
		maxamt = 0;
		for (i=0; i<maxnoc; i++) {
			if (i == cnum && !god)
				continue;
			if ((n = commamt(i, product, &price)) <= 0)
				continue;
			if (number < 0 || price < bestprice ||
			    (price==bestprice && n > maxamt) ) {
				bestprice = price;
				maxamt = n;
				number = i;
				amt = n;
			}
		}
		if (number < 0)
			continue;
		pr(fmt("%-12.12s (#%2d) %12.12s %7d %7.2f\n",
			ip->i_name, number, cname(number), amt, bestprice));
	}
	return RET_OK;
}
