#ifndef lint
static char *RCSid = "$Header: look.c 1.7 89/03/17 $";
#endif

/*
 * look.c
 *
 * lookout from a ship
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "nsc.h"

look()
{
	extern	char *alloca();
	extern	double tfact();
	extern	char *fmt();
	extern	char *argp[];
	extern	int cnum;
	extern	int shipf;
	extern	struct dchrstr dchr[];
	extern	struct mchrstr mchr[];
	extern	struct shpstr ship;
	extern	struct sctstr sect;
	extern	int diroff[][2];
	extern	int owner;
	register int i;
	int	x;
	int	y;
	int	bar;
	struct	nbstr nb;
	int	size;
	struct	shpstr *shp;
	int	nship;
	int	civ;
	int	mil;

	if (snxtshp(&nb, argp[1], cnum, " From ship(s)? ") < 0)
		return RET_SYN;
	size = fsize(shipf);
	nship = size / sizeof(struct shpstr);
	shp = (struct shpstr *) alloca(size);
	m_readship(shp, nship);
	while (nxtshp(&nb, &ship)) {
		look_ship(shp, nship, &ship);
		bar = wethr(ship.shp_x, ship.shp_y, 0);
		if (bar < 730)
			continue;
		for (i = 0; i <= 6; i++) {
			x = diroff[i][0] + ship.shp_x;
			y = diroff[i][1] + ship.shp_y;
			getsect(x, y);
			if (sect.sct_type == SCT_WATER)
				continue;
			if (owner)
				pr("Your ");
			else
				pr(fmt("%s (#%d) ", cname(sect.sct_own),
					sect.sct_own));
			pr(dchr[sect.sct_type].d_name);
			pr(fmt(" %d%% efficient ", owner ? sect.sct_effic :
				round(sect.sct_effic, 10)));
			civ = gsctv(V_CIVIL);
			mil = gsctv(V_MILIT);
			if (civ)
				pr(fmt("with %s%d civ ", owner ? "" : "approx ",
					owner ? civ : round(civ, 10)));
			if (mil)
				pr(fmt("with %s%d mil ", owner ? "" : "approx ",
					owner ? mil : round(mil, 10)));
			pr(fmt("@ %d,%d\n", x, y));
		}
	}
	return RET_OK;
}

look_ship(shp, nship, s)
	struct	shpstr *shp;
	int	nship;
	register struct shpstr *s;
{
	extern	double techfact();
	register struct shpstr *sp;
	register int n;
	register struct mchrstr *smcp;
	register struct mchrstr *tmcp;
	float	range;
	float	rsq;
	int	lx;
	int	ly;
	int	hx;
	int	hy;
	float	dsq;
	char	*name;

	range = techfact(ship.shp_tech, (double) mchr[s->shp_type].m_vrnge);
	range *= (s->shp_effic / 100.0);
	rsq = range * range;
	lx = s->shp_x - ((2.0 * range) + 1.0);
	ly = s->shp_y - (range + 0.5);
	hx = s->shp_x + (2.0 * range) + 1.0;
	hy = s->shp_y + (range + 0.5);
	smcp = &mchr[s->shp_type];
	for (n = 0, sp = shp; n < nship; n++, sp++) {
		if (sp->shp_own == cnum || sp->shp_own == 0)
			continue;
		if (sp->shp_x < lx || sp->shp_y < ly)
			continue;
		if (sp->shp_x > hx || sp->shp_y > hy)
			continue;
		rsq = mchr[sp->shp_type].m_visib * range / 20.0;
		rsq *= rsq;
		dsq = mapdsq(sp->shp_x, sp->shp_y, s->shp_x, s->shp_y);
		tmcp = &mchr[sp->shp_type];
		if ((smcp->m_flags & M_SONAR) && (tmcp->m_flags & M_SUB)) {
			if (dsq > techfact(sp->shp_tech, 12.0))
				continue;
			/* if not in same sect, just see 'em on sonar */
			if (dsq >= 1.0)
				pr(fmt("Sonar contact at %d,%d\n",
					sp->shp_x, sp->shp_y));
		}
		if ((tmcp->m_flags & M_FOOD) && dsq > 0)
			name = "fishing vessel";
		else
			name = tmcp->m_name;
		if (dsq <= rsq) {
			/* subs only seen by ships with sonar */
			if (((tmcp->m_flags & M_SUB)) && ((smcp->m_flags & M_SONAR) == 0))
				continue;
			pr(fmt("%s (#%d) %s #%d @%d,%d\n",
				cname(sp->shp_own), sp->shp_own, name,
				n, sp->shp_x, sp->shp_y));
		}
	}
}
