static char *RCSid = "$Header: leve.c 1.7 89/03/17 $";

/*
 * leve.c
 *
 * do a distribution threshold level report
 *
 * David Muir Sharnoff, 1987
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nsc.h"
#include "news.h"

leve()
{
	extern	char *masktopath();
	extern	char *fmt();
	extern	char *argp[];
	extern	char dirch[];
	extern	int god;
	extern	int owner;
	extern	struct dchrstr dchr[];
	extern	struct sctstr sect;
	extern  float mcost();
	extern	float pathtoxy();
	char	*path;
	int	nsect;
	int	dstx;
	int	dsty;
	struct	nstr nstr;

	if (snxtsct(&nstr, argp[1]) < 0)
		return 2;
	prdate();
	nsect = 0;
	while (nxtsct(&nstr, 0)) {
		if (!owner)
			continue;
		if (nsect++ == 0) {
			pr("DISTRIBUTION LEVELS\n");
			if (god) 
				pr(fmt("own"));
			pr("  sect    path------   dst    uw food  sh gun pet iron dust bar oil lcm hcm rad\n");
		}
		path = masktopath(sect.sct_distpath);
		dstx = nstr.n_x;
		dsty = nstr.n_y;
		(void) pathtoxy(path, &dstx, &dsty, mcost);
		if (god)
			pr(fmt("%2d ", sect.sct_own));
		pr(fmt("%3d,%-3d", nstr.n_x, nstr.n_y));
		pr(fmt(" %c ", dchr[sect.sct_type].d_mnem));
		pr(fmt("%10s ", *path ? path : ""));
		pr(fmt("%3d,%-3d", dstx, dsty));
		pr(fmt("%4d", gsctv(V_UDIST)));
		pr(fmt("%5d", gsctv(V_FDIST)));
		pr(fmt("%4d", gsctv(V_SDIST)));
		pr(fmt("%4d", gsctv(V_GDIST)));
		pr(fmt("%4d", gsctv(V_PDIST)));
		pr(fmt("%5d", gsctv(V_IDIST)));
		pr(fmt("%5d", gsctv(V_DDIST)));
		pr(fmt("%4d", gsctv(V_BDIST)));
		pr(fmt("%4d", gsctv(V_ODIST)));
		pr(fmt("%4d", gsctv(V_LDIST)));
		pr(fmt("%4d", gsctv(V_HDIST)));
		pr(fmt("%4d", gsctv(V_RDIST)));
		pr("\n");
	}
	pr(fmt("    %d sector%s\n", nsect, splur(nsect)));
	return 0;
}
