static char *RCSid = "$Header: laun.c 1.10 89/03/17 $";

/*
 * laun.c
 *
 * Launch missiles from land or sea.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "plane.h"
#include "nuke.h"
#include "news.h"
#include "ship.h"
#include "unit.h"
#include "nsc.h"
#include "update.h"

struct target {
	int x,y;
	int airburst;
};

	struct	shpstr ship;
	struct	plchrstr *pcp;
	int	shefl;
/*
 * laun <PLANES>
 */
laun() {
	extern	char *fmt();
	extern	struct plchrstr plchr[];
	extern	struct nchrstr nchr[];
	extern	double dolcost;
	extern	char *argp[];
	extern	int sx, sy;
	extern	struct sctstr sect;
	extern	int cnum;
	extern  int diroff[][2];
	struct	ustr unit;
	struct	plnstr *pp;
	struct	nustr nu;
	int	n;
	char	*p;
	int	i;
	int	gas;

	if (snxtunit(&nu, U_PLANE, argp[1], cnum, "which missile? ") < 0)
		return RET_SYN;
	pp = &unit.u_plane;
	while (nxtunit(&nu, &unit)) {
		if (pp->pln_own != cnum)
			continue;
		pcp = &plchr[pp->pln_type];
		if ((pcp->pl_flags & (P_M|P_O)) == 0) {
			pr(fmt("%s #%d isn't a missile!\n", pcp->pl_name,
				pp->pln_uid));
			continue;
		}
		if((pp->pln_flags & PLN_LAUNCHED)&&(pcp->pl_flags & P_O)){
			pr(fmt("%s #%d already in orbit!\n",
				pcp->pl_name, pp->pln_uid));
			continue;
		}
		if (pp->pln_ship >= 0) {
			getship(pp->pln_ship, &ship);
			shefl = 1;
			if (ship.shp_own != cnum){
				continue;
			}
			pp->pln_x = ship.shp_x;
			pp->pln_y = ship.shp_y;
			gas = gshpv(V_PETROL, &ship);
		} else {
			shefl = 0;
			getsect(pp->pln_x, pp->pln_y);
			if (sect.sct_own != cnum) {
				pr(fmt("%s #%d: you don't own %d,%d!\n",
					pcp->pl_name, pp->pln_uid,
					pp->pln_x, pp->pln_y));
				continue;
			}
			gas = gsctv(V_PETROL);
		}
		if (pcp->pl_fuel > gas) {
			pr(fmt("(#%d) %s: not enough petrol there!\n",
				pp->pln_uid, pcp->pl_name));
			continue;
		}
		if (shefl != 0)
			pshpv(V_PETROL, gas - pcp->pl_fuel, &ship);
		else
			psctv(V_PETROL, gas - pcp->pl_fuel);
		if (pp->pln_effic < 60) {
			pr(fmt("%s #%d is damaged (%d%%)\n",
				pcp->pl_name, pp->pln_uid, pp->pln_effic));
			continue;
		}
		pr(fmt("%s #%d at %d,%d; range %d, eff %d%%", pcp->pl_name,
			pp->pln_uid, pp->pln_x, pp->pln_y, pp->pln_range,
			pp->pln_effic));
		n = pp->pln_nukeamt;
		/**First send missiles with shells**/
		if((! (pcp->pl_flags & P_O)) && (n == 0)){
			if (launch_conv(pp) < 0)
				continue;
		} else if(n == 0){	/* It must be a satellite */
			if (launch_sat(pp) < 0)
				continue;
		} else {
			if (launch_nuke(pp,n) < 0)
				continue;
		}
		putplane(pp->pln_uid, pp);
	/*
	 * The launch must have succeeded (or the missile blew up)
	 * - therefore subtract from ship number, and take
	 *   away the fuel, and shells used
	 */
		if (shefl != 0) {
			ship.shp_nplane -= 1;
			if (ship.shp_nplane < 0)
				ship.shp_nplane = 0;
			putship(pp->pln_ship, &ship);
		} else {
			putsect(sect.sct_x, sect.sct_y);
		}
		sigrest();
	}
	return RET_OK;
}

/* This was all grabbed from fly.c, fly1.c */

launch_conv(pp)
	struct	plnstr *pp;
{
	extern	struct sctstr sect;
	extern	int sx,sy;
	extern	int cnum;
	struct	sctstr save_sect;
	float	eff;
	float	damage;
	int	dam;
	int	shell;
	int	bombs;
	int	needed;
	int	i;

	pr(", carrying conventional warhead\n");
	if (shefl != 0) {
		shell = gshpv(V_SHELL, &ship);
	} else {
		shell = gsctv(V_SHELL);
	}
	needed = pcp->pl_load - 1;
	if (shell < needed) {
		pr(fmt("(#%d) %s not enough shells!\n",
			pp->pln_uid, pcp->pl_name));
		return -1;
	}
	bombs = pcp->pl_load;
	if (shefl != 0) {
		pshpv(V_SHELL, shell - needed, &ship);
	} else {
		psctv(V_SHELL, shell - needed);
	}
	bcopy((char *) &sect, (char *) &save_sect, sizeof(struct sctstr));
	while(1){
		if (getsno(0, "Target sector? ") < 0)
			continue;
		if (mapdist(pp->pln_x, pp->pln_y, sx, sy) > pp->pln_range) {
			pr("Range too great; try again!\n");
			continue;
		}
		break;
	}
	pr("Launching!!!\n");
	eff = 100.0;
	i = roll(100);
	if (i <= 10) {
		damage = 0.92;	/* 8% */
		pr("BLAM");
	} else if (i < 100 - pcp->pl_acc) {
		damage = 0.95;	/* 5% */
		pr("Blam");
	} else {
		damage = 0.98;	/* 2% */
		pr("blam");
	}
	pr("\n");
	for (i = 0; i < bombs; i++)
		eff *= damage;
	pp->pln_own = 0;
	sigsave();
	if (chance(0.02 + (100 - pp->pln_effic)/100.0)) {
		pr("KABOOOOM!  Missile explodes on launch pad!\n");
		bcopy((char *) &save_sect,
			(char *) &sect, sizeof(struct sctstr));
		return 0;
	}
	dam = 100.0 - eff;
	sectdamage(sx, sy, dam);
	putsect(sx, sy);
	nreport(cnum, N_SCT_BOMB, sect.sct_own, 1);
	pr(fmt("did %d%% damage in %d,%d\n", dam, sx, sy));
	wu(0, sect.sct_own,
		fmt("%s bombing raid did %d%% damage in %s",
		cname(cnum), dam, xytoa(sx, sy, sect.sct_own)));
	bcopy((char *) &save_sect, (char *) &sect, sizeof(struct sctstr));
	return 0;
}

launch_sat(pp)
	struct	plnstr *pp;
{
	extern	struct sctstr sect;
	extern	int sx,sy;
	extern	int cnum;
	struct	sctstr save_sect;
	int	i;
	int	dm;
	int	dist;
	int	dir;

	pr("\n");
	bcopy((char *) &sect, (char *) &save_sect, sizeof(struct sctstr));
	while(1){
		if (getsno(0, "Target sector? ") < 0)
			continue;
		if ((dist=mapdist(pp->pln_x, pp->pln_y, sx, sy)) >
		    pp->pln_range) {
			pr("Range too great; try again!\n");
			continue;
			}
		break;
	}
	pr("3... 2... 1... Blastoff!!!\n");
	sigsave();
	if (chance((100 - pp->pln_effic)/100.0)) {
		pr(fmt("KABOOOOM!  Rocket explodes on launch pad!\n"));
		pp->pln_own = 0;
		if(shefl != 0){
		    putship(ship.shp_uid,&ship);
		    dm = shelldam(pcp->pl_fuel,pcp->pl_acc);
		    if (dm > 0) {
			pr(fmt("%s (%d) takes %d% damage from the explosion\n",
			mchr[ship.shp_type].m_name,  ship.shp_uid, dm));
			    shipdamage(&ship,dm);
		    }
		}
		bcopy((char *) &save_sect,
			(char *) &sect, sizeof(struct sctstr));
		return 0;
	}
	i = pp->pln_tech + pp->pln_effic;
	if(chance(1.0 - (i/(i+50.0)))){
		dir = (random()%6) + 1;
		sx += diroff[dir][0];
		sy += diroff[dir][1];
		pr("Your trajectory was a little off.\n");
	}
	nreport(cnum, N_LAUNCH, 0, 1);
	pr(fmt("%s #%d positioned over %d,%d, ",
		pcp->pl_name, pp->pln_uid, sx, sy));
	pp->pln_x = sx;
	pp->pln_y = sy;
	pp->pln_flags |= PLN_LAUNCHED;
	pp->pln_mobil = (pp->pln_mobil > dist) ? 
		(pp->pln_mobil - dist) : 0;
	pr(fmt("will be ready for use in %d updates\n",
		(127 + MOB_ETU - 1 - pp->pln_mobil) / MOB_ETU));
	pr(fmt("dist = %d, mobil = %d\n", dist, pp->pln_mobil));
	bcopy((char *) &save_sect, (char *) &sect, sizeof(struct sctstr));
	return 0;
}

launch_nuke(pp,n)
struct plnstr *pp;
int n;
{
	extern	char *getstring();
	extern	struct sctstr sect;
	extern	int sx,sy;
	extern	int cnum;
	struct	sctstr save_sect;
	struct	target xy[20];
	char	*p;
	int	i;
	int	dir;

	pr(fmt(", payload %dx%s\n", pp->pln_nukeamt,
			nchr[pp->pln_nuketype].n_name));
	if (n > 20)
		n = 20;
	bcopy((char *) &sect, (char *) &save_sect, sizeof(struct sctstr));
	for (i=0; i < n; ) {
		if (getsno(0, fmt("RV #%d, target sector? ", i+1)) < 0)
			continue;
		if (mapdist(pp->pln_x, pp->pln_y, sx, sy) >
		    pp->pln_range) {
			pr("Range too great; try again!\n");
			continue;
		}
		if(pcp->pl_flags & P_O){
			dir = pp->pln_tech + pp->pln_effic;
			if(chance(1.0 - dir/(dir+50.0)))
				dir = (random()%6) + 1;
			else
				dir = 0;
			xy[i].x = sx + diroff[dir][0];
			xy[i].y = sy + diroff[dir][1];
			xy[i].airburst = 2;
			}
		else{
			p = getstring("Air-burst? ");
			xy[i].x = sx;
			xy[i].y = sy;
			xy[i].airburst = 1;
			if (p == 0 || *p == 0 || *p == 'n')
				xy[i].airburst = 0;
			if(shefl != 0){
			    putship(ship.shp_uid,&ship);
			}
		}
		i++;
	}

	pp->pln_own = 0;
	pp->pln_nukeamt = 0;
	sigsave();
	pr("Launching!!!\n");
	if (chance(0.02 + (100 - pp->pln_effic)/100.0)) {
		pr(fmt("KABOOOOM!  Missile explodes on launch pad!\n"));
		bcopy((char *) &save_sect,
			(char *) &sect, sizeof(struct sctstr));
		return 0;
	}
	pr("Arming warheads...\n");
	pr("Releasing RV's...\n");
	for (i=0; i<n; i++) {
		detonate(pp->pln_nuketype, xy[i].x, xy[i].y,
			xy[i].airburst, cnum);
	}
	bcopy((char *) &save_sect, (char *) &sect, sizeof(struct sctstr));
	return 0;
}
