static char *RCSid = "$Header: info.c,v 1.6 88/05/04 00:53:09 c188-cz Exp $";

/*
 * $Log:	info.c,v $
 * Revision 1.6  88/05/04  00:53:09  c188-cz
 * after okamoto patch 05
 * HPUX compatability
 * 
 * Revision 1.5  88/04/01  04:38:44  muir
 * rcsid now at top
 * 
 */

/*
 * info.c
 *
 * get documentation from INFO directory.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include <stdio.h>
#include <sys/stat.h>
#ifdef hpux
#include <ndir.h>
#else
#include <sys/dir.h>
#endif

#ifdef hpux
#define index strchr
#define rindex strrchr
#endif

DIR	*info_dp;

info () {
	extern	FILE *fopen();
	extern	char *rindex();
	extern	char *fmt();
	extern	char *argp[];
	extern	int errno;
	extern	char *infodir;
	char	buf[255];
	FILE	*fp;
	char	*bp;
	struct	stat statb;
	struct	direct *dp;

	if (argp[1] == 0 || !*argp[1])
		return printdir ();
	/*
	 * don't let sneaky people go outside the info directory
	 */
	bp = rindex(argp[1], '/');
	if (bp > 0)
		bp++;
	else
		bp = argp[1];
	if (info_dp == 0) {
		info_dp = opendir(infodir);
		if (info_dp == 0) {
			pr(fmt("Can't open %s\n", infodir));
			return RET_FAIL;
		}
	}
	rewinddir(info_dp);
	fp = fopen(fmt("%s/%s", infodir, bp), "r");
	if (fp == NULL) {
		int	len = strlen(bp);
		/*
		 * may be a "partial" request.
		 */
		while  ((dp = readdir(info_dp)) != 0 && fp == 0) {
			if (strncmp(bp, dp->d_name, len) != 0)
				continue;
			fp = fopen(fmt("%s/%s", infodir, dp->d_name), "r");
		}
		if (fp == NULL) {
			pr(fmt("Sorry, there is no info on %s\n", bp));
			return RET_OK;
		}
	}
	if (fstat(fileno(fp), &statb) < 0) {
		pr(fmt("Cannot read (%d) info page %s\n", errno, dp->d_name));
		return RET_FAIL;
	}
	if ((statb.st_mode & S_IFREG) == 0) {
		pr(fmt("Sorry, there is no info on %s\n", dp->d_name));
		return RET_FAIL;
	}
	pr(fmt("Info on %s: last mod date %s", bp, ctime(&statb.st_mtime)));
	while (fgets(buf, sizeof(buf), fp) != 0)
		pr(buf);
	(void) fclose(fp);
	return 0;
}

static int biggest;

static int fileselect (dp)
struct direct *dp;
{
	if (*dp->d_name == '.')
		return 0;

	if (dp->d_namlen > biggest)
		biggest = dp->d_namlen;
	return 1;
}

printdir ()
{
	static time_t lastmodtime;
	static int number;
	static struct direct **dp;
	struct stat st;
	int	count;
	int	i;
	int	npl;
	extern int alphasort ();

	if (stat (infodir, &st) == -1)
		return RET_FAIL;
	pr("Available topics are:\n");
	if (lastmodtime < st.st_mtime) {
		if (dp) free ((char *)dp);
		biggest = 0;
		number = scandir (infodir, &dp, fileselect, alphasort);
		lastmodtime = st.st_mtime;
	}
	count = 79 / (biggest + 1) - 1;
	for(i = 0, npl = 0; i < number; i++) {
		pr(fmt("%-*.*s%c", biggest, dp[i]->d_namlen,
		       dp[i]->d_name, npl == count ? '\n' : ' '));
		if (npl == count)
			npl = 0;
		else	npl ++;
	}
	if (npl != 0) pr("\n");
	return 0;
}
