static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/give.c,v 1.5 89/05/10 01:56:50 muir Exp $";

/*
 * give.c
 *
 * David Muir Sharnoff
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "xy.h"
#include "nsc.h"
#include "item.h"
#include "deity.h"
#include "file.h"

/*
 * format: give c <amt> <commod> <sect>
 */
give()
{
	extern	char *argp[];
	extern	int maxnoc;
	struct	sctstr sect;
	char	*p;
	char	*what;
	int	amt;
	struct	ichrstr *ip;
	int	n;
	coord	x, y;
	int	coun;

	if ((what = getstarg(argp[1], "Give What (commodites, money)? ")) == 0)
		return RET_OK;
	if ((amt = atoi(getstarg(argp[2],"how much : "))) == 0)
		return RET_OK;
	switch(*what) {
	case 'c':
		if ((ip = whatitem(argp[3], "which commodity : ")) == 0)
			return RET_OK;
		if ((p = getstarg(argp[4], "destination sector : ")) == 0)
			return RET_OK;
		if (!sarg_xy(p, &x, &y))
			return RET_OK;
		if (!getsect(x, y, &sect))
			return RET_OK;
		n = getvar(ip->i_vtype, &sect, EF_SECTOR);
		if (amt + n > 9990 || amt + n < 0) {
			pr("Sector cannot hold that much!\n");
			return RET_OK;
		}
		if (putvar(ip->i_vtype, n + amt, &sect, EF_SECTOR) < 0) {
			pr(fmt("No room to store %s in %s\n",
				ip->i_name, ownxy(&sect)));
			return 0;
		}
		putsect(&sect);
		if (amt >0) {
			nreport(cnum, N_GIFT, sect.sct_own, 1);
			wu(0, sect.sct_own, fmt("%s gave you %d %s in %s\n",
				cname(cnum), amt, ip->i_name, 
				ownxy(&sect)));
		} else {
			nreport(sect.sct_own, N_TAKE, cnum, 1);
			wu(0, sect.sct_own, fmt("%s stole %d %s from %s\n",
				cname(cnum), -amt, ip->i_name, ownxy(&sect)));
		}
		pr(fmt("%d %s in %s\n", n+amt, ip->i_name,
			xyas(sect.sct_x, sect.sct_y, cnum)));
		break;

	case 'm':
		if ((coun = natarg(argp[3], "To? ")) < 0)
			return RET_SYN;
		NAT_DELTA(nat_money, coun, amt);
		if (amt > 0) {
			nreport(cnum, N_GIFT, sect.sct_own, 1);
			wu(0, sect.sct_own, fmt("%s gave you $%d.\n",
				cname(cnum), amt)); 
		} else {
			nreport(sect.sct_own, N_GIFT, cnum, 1);
			wu(0, sect.sct_own, fmt("%s took $%d from your bank.\n",
				cname(cnum), -amt)); 
		}
		break;

	default:
		pr("huh?\n");
		return RET_SYN;
	}
	return RET_OK;
}
