static char *RCSid = "$Header: fire.c 1.8 89/03/17 $";

/*
 * fire.c
 *
 * fire at other sectors, ships.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "ship.h"
#include "sect.h"
#include "news.h"

fire()
{
	extern	double tfact();
	extern	double techfact();
	extern	double landgun();
	extern	double seagun();
	extern	double shipdef();
	extern	double defdef();
	extern	char *getstarg();
	extern	char *fmt();
	extern	char *argp[];
	extern	int lx, ly;
	extern	struct sctstr sect;
	extern	struct dchrstr dchr[];
	extern	struct mchrstr mchr[];
	extern	int cnum;
	extern	int btused;
	register char *r11;
	register int r10;
	char	buf[48];
	int	f_x;
	int	f_y;
	int	x;
	int	y;
	int	fshipno;
	int	vshipno;
	int	fromtype;
	int	totype;
	int	f64;
	int	f68;
	int	vict;
	int	dam;
	int	mil;
	int	gun;
	int	shell;
	int	f84;
	double	f8c;
	double	f9c;
	double	fb4;
	double	fbc;
	struct	shpstr fship;
	struct	shpstr vship;
	double	f10c;
	int	depthcharge;

	depthcharge = 0;
	r11 = getstarg(argp[1], "Firing on ");
	if ((totype = landorsea(r11)) == LAND) {
		if (sargs(r11) < 0 || getsect(lx, ly) < 0)
			return 2;
		if (sect.sct_type == SCT_SANCT) {
			pr(fmt("%d,%d is a %s!!\n", lx, ly,
				dchr[sect.sct_type].d_name));
			return 1;
		}
		vict = sect.sct_own;
		x = lx;
		y = ly;
		f68 = landdef(sect.sct_type);
		r11 = fmt("Firing on sector %d,%d from ", x, y);
	} else {
		if ((vshipno = getshno(r11, "Victim ship? ", &vship)) < 0
				|| vship.shp_own == 0) {
			pr("No such ship exists\n");
			return 2;
		}
		vict = vship.shp_own;
		x = vship.shp_x;
		y = vship.shp_y;
		f68 = seadef(vship.shp_type);
		if (mchr[vship.shp_type].m_flags & M_SUB)
			depthcharge = 2;
		r11 = fmt("Firing on ship #%d from ", vshipno);
	}
	r11 = getstarg(argp[2], r11);
	if ((fromtype = landorsea(r11)) == LAND) {
		if (sargs(r11) < 0)
			return 2;
		if (getmysect(lx, ly, 0) < 0)
			return 2;
		if (sect.sct_type != SCT_FORTR) {
			pr("Not a fortress\n");
			return 2;
		}
		if ((gun = gsctv(V_GUN)) == 0) {
			pr("Insufficient arms\n");
			return 2;
		}
		if ((shell = gsctv(V_SHELL)) == 0) {
			pr("Klick!     ...\n");
			return 2;
		}
		if (gsctv(V_MILIT) < 5) {
			pr("Not enough military for firing crew\n");
			return 2;
		}
		if (depthcharge) {
			pr("Victim ship not sighted\n");
			return 2;
		}
		psctv(V_SHELL, shell - 1);
		f84 = 1;
		f10c = min(gun, 7);
		f8c = f10c;
		f8c = tfact(cnum, f8c);
		pr(fmt("range is %.2f\n", f8c));
		f9c = landgun(sect.sct_effic);
		f64 = landdef(sect.sct_type);
		putsect(lx, ly);
		f_x = lx;
		f_y = ly;
	} else {
		if (getmyship(fshipno = atopi(r11), &fship) < 0)
			return 2;
		if ((mil = gshpv(V_MILIT, &fship)) < 1) {
			pr("Not enough military for firing crew\n");
			return 2;
		}
		if (depthcharge) {
			if ((mchr[fship.shp_type].m_flags & M_DCH) == 0) {
				pr(fmt("A %s can't drop depth charges!\n",
					mchr[fship.shp_type].m_name));
				return 2;
			}
			depthcharge++;
		}
		gun = gshpv(V_GUN, &fship);
		if (mchr[fship.shp_type].m_frnge == 0 || gun == 0) {
			pr("Insufficient arms\n");
			return 2;
		}
		if ((shell = gshpv(V_SHELL, &fship)) == 0 ||
				(depthcharge && shell < 2)) {
			pr("Klick!     ...\n");
			return 2;
		}
		if (fship.shp_effic < 60) {
			pr(fmt("Ship #%d is crippled (%d%%)\n", fshipno,
				fship.shp_effic));
			return 2;
		}
		f_x = fship.shp_x;
		f_y = fship.shp_y;
		f8c = techfact(fship.shp_tech,
			mchr[fship.shp_type].m_frnge / 2.0);
		if (!depthcharge) {
			pr(fmt("Efficiency %d%%, max range %.2f  ",
				fship.shp_effic, f8c));
			r10 = min(min(mchr[fship.shp_type].m_glim, gun), shell);
			r10 = min(r10, mil/2);	/* one gun per 2 crew */
			f84 = onearg(argp[3],
				fmt("How many guns (%d max) ?", r10));
			if ((f84 = min(r10, f84)) == 0)
				return 1;
		} else {
			f84 = depthcharge;
			if (f_x != x || f_y != y) {
				pr("Y-guns can't shoot that far!\n");
				return 1;
			}
		}
		pshpv(V_SHELL, shell - f84, &fship);
		f9c = seagun(fship.shp_type, fship.shp_effic, f84);
		f64 = seadef(fship.shp_type);
		fship.shp_mobil = max(fship.shp_mobil - 15, -100);
		putship(fshipno, &fship);
	}
	f10c = mapdsq(f_x, f_y, x, y);
	fbc = f10c;
	if (totype == SEA && fbc > 50.0) {
		pr("Victim ship not sighted\n");
		return 2;
	}
	if (fbc < 50.0) {
		if (totype && vict && trechk(cnum, vict, 8) < 0)
			return 2;
		if (!totype && trechk(cnum, vict, 2) < 0)
			return 2;
	}
	if (depthcharge)
		pr("Kawhomp!!!\07\n");
	else {
		pr("Kaboom!!!\07\n");
		fb4 = fbc / (f8c * f8c);
		fb4 *= fb4;
		if (fb4 >= 1.0) {
			pr(fmt("Out of range, shell%s short.\n",
				f84 == 1 ? " falls" : "s fall"));
			return 1;
		}
		if (chance(fb4)) {
			pr(fmt("Wind deflects shell%s.\n", splur(f84)));
				f9c *= (rand() & 03) ? 0.5 : 1.0 - fb4;
		}
	}
	sigsave();
	dam = shelldam(f9c, f68);
	btused = btused + (f9c / 20.0) + 0.5;
	if (totype == LAND) {
		nreport(cnum, N_SCT_SHELL, vict, 1);
		if (vict != cnum)
			wu(0, vict,
				fmt("Country #%d shell%s did %d%% damage in %s",
				cnum, splur(f84), dam, xytoa(x, y, vict)));
		getsect(x, y);
		pr(fmt("%d%% damage done to sector %d,%d\n", dam, x, y));
		sectdamage(x, y, dam);
		putsect(x, y);
		if ((dam = fortdef(x, y, f64, f_x, f_y))) {
			if (fromtype) {
				getsect(f_x, f_y);
				sectdamage(f_x, f_y, dam);
				putsect(f_x, f_y);
				copy(fmt("sector %s", xytoa(f_x, f_y, vict)),
					buf);
			} else {
				getship(fshipno, &fship);
				shipdamage(&fship, dam);
				putship(fshipno, &fship);
				copy(fmt("%s #%d @ %s",
					mchr[fship.shp_type].m_name, fshipno,
					xytoa(f_x, f_y, vict)), buf);
			}
	wu(0, vict, fmt("Sector %s return fire did %d%% damage to %s",
		xytoa(x, y, vict), dam, buf));
		}
		if ((dam = defdef(x, y, f64, f_x, f_y)) == 0)
			return 0;
		if (fromtype == 0) {
			getsect(f_x, f_y);
			sectdamage(f_x, f_y, dam);
			putsect(f_x, f_y);
			copy(fmt("sector %s", xytoa(f_x, f_y, vict)), buf);
		} else {
			getship(fshipno, &fship);
			shipdamage(&fship, dam);
			putship(fshipno, &fship);
			copy(fmt("%s #%d @ %s", mchr[fship.shp_type].m_name,
				fshipno, xytoa(f_x, f_y, vict)), buf);
		}
		wu(0,vict,fmt("Fortress(es) defending %s did %d%% damage to %s",
			xytoa(x, y, vict), dam, buf));
		return 0;
	}
	shipdamage(&vship, dam);
	nreport(cnum, N_SHP_SHELL, vict, 1);
	wu(0, vict, fmt("Country #%d shell%s did %d%% damage to  %s #%d",
		cnum, splur(f84), dam, mchr[vship.shp_type].m_name, vshipno));
	putship(vshipno, &vship);
	if (vship.shp_effic > 20)
		pr(fmt("%d%% damage done to %s #%d\n", dam,
			mchr[vship.shp_type].m_name, vshipno));
	if ((dam = shipdef(vict, f64, f_x, f_y)) == 0)
		return 0;
	if (fromtype == LAND) {
		wu(0, vict, fmt("Return fire did %d%% damage to %s",
			dam, xytoa(f_x, f_y, vict)));
		getsect(f_x, f_y);
		sectdamage(f_x, f_y, dam);
		putsect(f_x, f_y);
	} else {
		wu(0, vict, fmt("Return fire did %d%% damage to %s #%d",
			dam, mchr[fship.shp_type].m_name, fshipno));
		getship(fshipno, &fship);
		shipdamage(&fship, dam);
		putship(fshipno, &fship);
	}
	return 0;
}
