static char *RCSid = "$Header: enli.c 1.4 89/03/17 $";

/*
 * enli.c
 *
 * enlist some military
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "treaty.h"

enli()
{
	extern	char *fmt();
	extern	char *getstarg();
	extern	char *argp[];
	extern	struct sctstr sect;
	extern	struct natstr *natp;
	extern	int btused;
	extern	int owner;
	extern	int cnum;
	extern	int god;
	extern	int owner;
	extern	int pop_strike;
	register int mil_want;
	register int newmil;
	int	civ;
	int	mil;
	int	totalmil;
	float	f10;
	struct	nstr nstr;
	float	f58;
	int	reserve;
	int	n;

	if (snxtsct(&nstr, argp[1]) == -1)
		return 2;
	if (trechk(cnum, 0, TRTENL) == -1)
		return 1;
	getnat(cnum);
	newmil = 500;
	mil_want = atoi(getstarg(argp[2],
		fmt("Number to enlist (max %d) : ", newmil)));
	if (!god && mil_want > newmil)
		mil_want = newmil;
	totalmil = 0;
	reserve = natp->nat_reserve;
	if (reserve <= 0) {
		pr("No military reserves left\n");
		return RET_OK;
	}
	sigsave();
	for (totalmil = 0; nxtsct(&nstr, 0); ) {
		if (!owner)
			continue;
#ifdef notdef
		if (sect.sct_type == SCT_URBAN)
			continue;
#endif
		if (sect.sct_oldown != cnum)
			continue;
		civ = gsctv(V_CIVIL);
		if (civ == 0)
			continue;
		if (sect.sct_loyal > 70) {
			pr(fmt("civilians refuse to report in %d,%d!\n",
				sect.sct_x, sect.sct_y));
			continue;
		}
		mil = gsctv(V_MILIT);
		newmil = civ * 0.5;
		if (mil_want <= 0) {
			/*
			 * enlist up to a given number of troops.
			 */
			if (newmil > -mil_want - mil)
				newmil = -mil_want - mil;
			if (newmil > 500)
				newmil = 500;
		} else if (newmil > mil_want)
			newmil = mil_want;
		if (newmil > 999 - mil)
			newmil = 999 - mil;
		if (newmil <= 0)
			continue;
		if (newmil > reserve)
			newmil = reserve;
		if (psctv(V_MILIT, newmil + mil) < 0) {
			pr(fmt("No room for military in %d,%d\n",
				nstr.n_x, nstr.n_y));
			continue;
		}
		reserve -= newmil;
		psctv(V_CIVIL, civ - newmil);
		pr(fmt("%3d enlisted in %d,%d (%d)\n", newmil,
			nstr.n_x, nstr.n_y, mil + newmil));
		f58 = (float) newmil / (float) civ;
		f10 = 1.0 - f58;
		sect.sct_mobil = sect.sct_mobil * f10;
		putsect(nstr.n_x, nstr.n_y);
		totalmil += newmil;
		if (totalmil >= 10000) {
			pr("Rioting in induction center interrupts enlistment\n");
			break;
		}
		if (reserve == 0) {
			pr("Military reserve exhausted\n");
			break;
		}
	}
	pr(fmt("Total new enlistment : %d\n", totalmil));
	pr(fmt("Military reserves stand at %d\n", reserve));
	NAT_DELTA(nat_reserve, cnum, -totalmil);
	n = totalmil * 0.02 + 0.5;
	if (n > 0) {
		pr(fmt("Paperwork at recruiting stations ... %d\n", n));
		btused += n;
	}
	sigrest();
	return 0;
}
