
static char *RCSid = "$Header: edit.c 1.4 89/03/17 $";

/*
 * edit.c
 *
 * David Muir Sharnoff
 */

#include <ctype.h>
#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "nsc.h"
#include "item.h"


/*
 * format: give c <amt> <commod> <sect>
 */
edit() {
	extern	char *getstarg();
	extern	char *fmt();
	extern	char *getstring();
	extern	struct ichrstr *whatitem();
	extern	char *argp[];
	extern	int cnum;
	extern	int god;
	extern	struct sctstr sect;
	extern	struct natstr *natp;
	extern	int maxnoc;
	char	*what;
	int	amt;

	if ((what = getstarg(argp[1], "Edit What (country, land, ship, plane, nuke, treaty)? ")) == 0) 
		return 0;

	switch(*what) {

	case 'l':
	{
	    char	*sctpstr = argp[2];
	    char	*doit;
	    char	*str;
	    char	com;
	    extern  struct dchrstr dchr[];

	    pr("Editing sector\n");

	    for (;;) {
		    if (getsno(sctpstr, "sector : ") == -1)
			    return 0;
		    sctpstr = 0;
		    if (argp[3] == 0 || strlen(argp[3]) == 0) {
			    pr("  sect    own oo eff mob min gld frt oil urn wrk lty  che plg\n");
			    pr("things:     o  O   e   m   i   g   a   p   u   w   l    c h\n");
			    prsct();
		    } 
			    
		    if ((doit = getstarg(argp[3], "%c%d -- thing value (pairs): ")) == 0)
			    return 0;

		    while (*doit && *(doit+1)) {
			while(isspace(*doit)) ++doit;
			com = *doit;
			amt = atoi(++doit);
			str = doit;
			while(isprint(*doit) && !isspace(*doit)) ++doit;
			if (isprint(*doit)) {
				*doit = '\0';
				++doit;
			}

			switch (com) {
			case 'o':
			{
				int newown = natarg(str, "New Owner : ");
				if (newown == -1) return RET_SYN;
				pr(fmt("owner of %d,%d changed from %s (#%d) to %s (#%d).\n",sect.sct_x, sect.sct_y, cname(sect.sct_own), sect.sct_own, cname(newown), newown));
				wu(0, sect.sct_own, fmt("sector %s lost to diety intervention", ownxy(&sect)));
				sect.sct_own = newown;
				putsect(sect.sct_x, sect.sct_y);
				wu(0, newown, fmt("sector %s gained from diety intervention", ownxy(&sect)));
				benifit(sect.sct_own, 0);
				benifit(newown, 1);
				break;
			}
			case 'O':
			{
				int oldown = natarg(str, "New Old Owner : ");
				if (oldown == -1) return RET_SYN;
				pr(fmt("old owner of %d,%d changed from %s (#%d) to %s (#%d).\n",sect.sct_x, sect.sct_y, cname(sect.sct_oldown), sect.sct_oldown, cname(oldown), oldown));
				sect.sct_oldown = oldown;
				putsect(sect.sct_x, sect.sct_y);
				benifit(sect.sct_own,sect.sct_own == oldown);
				wu(0, sect.sct_own, fmt("sector %s touched by god", ownxy(&sect)));
				break;
			}
			case 'e':
				modsct1(1,1,"efficiency", amt, &sect.sct_effic);
				break;
			case 'm':
				modsct1(1,1,"mobility", amt, &sect.sct_mobil);
				break;
			case 'i':
				modsct1(1,1,"iron ore content", amt, &sect.sct_min);
				break;
			case 'g':
				modsct1(1,1,"gold ore content", amt, &sect.sct_gmin);
				break;
			case 'a':
				modsct1(1,1,"fertility", amt, &sect.sct_fertil);
				break;
			case 'p':
				modsct1(1,1,"oil content", amt, &sect.sct_oil);
				break;
			case 'u':
				modsct1(1,1,"uranium ore", amt, &sect.sct_uran);
				break;
			case 'w':
				modsct1(1,1,"work", amt, &sect.sct_work);
				break;
			case 'l':
				modsct1(0,0,"dissention", amt, &sect.sct_loyal);
				break;
			case 'c':
				modsct2(0,0,"guerrillas", amt, V_CHE);
				break;
			case 'h':
				modsct2(0,0,"plague stage", amt, V_PSTAGE);
				break;
			default:
				pr(fmt("huh? (%c)\n",com));
				return RET_SYN;
			}
		    }
		    if (argp[3] == 0 || strlen(argp[3]) == 0) {
			prsct();
		    } else {
			return 0;
		    }
	    }

	}

	case 'c':
	{
		struct	natstr	*np;
		int	nat;
		char	*doit;
		char	*edarg;
		char	com;

		char	*strarg;
		int	intarg;
		int	sectarg[2];
		float	farg;
		
		nat = natarg(argp[2], "Edit Nation : ");
		if (nat == -1) return RET_SYN;

		edarg = argp[3];

		prnat(nat);

		np = getnat(nat);

		for(;;) {
			if ((doit = getstarg(edarg, "%c xxxxx -- thing value : ")) == 0) {
				prnat(nat);
				return 0;
			}
			edarg = 0;

			while(isspace(*doit)) ++doit;
			com = *doit;


			if (*doit == '\0') {
				prnat(nat);
				return 0;
			}

			++doit;

			while(isspace(*doit)) ++doit;

			sscanf(doit, "%f", &farg);
			sscanf(doit, "%d,%d", sectarg, sectarg+1);
			strarg = doit;
			strarg[19] = '\0';
			intarg = atoi(doit);

/*			pr(fmt("_%f_%d_%d,%d_%s\n",farg,intarg,sectarg[0],sectarg[1],strarg)); */

			switch (com) {
			case 'n':
				NAT_SET(nat_cnam[0], nat, strarg); break;
			case 'r':
				NAT_SET(nat_pnam[0], nat, strarg); break;
			case 'b':
				NAT_SET(nat_btu, nat, intarg); break;
			case 'f':
				NAT_SET(nat_flags, nat, intarg); break;
			case 'm':
				benifit(nat, np->nat_reserve < intarg);
				wu(0, nat, fmt("Military Reserves modified by divine intervention from %d to %d", np->nat_reserve, intarg));
				NAT_SET(nat_reserve, nat, intarg);
				break;
			case 'l':
				NAT_SET(nat_login, nat, intarg); break;
			case 't':
				NAT_SET(nat_tgms, nat, intarg); break;
			case 'c':
				NAT_SET(nat_xcap, nat, sectarg[0]);
				NAT_SET(nat_ycap, nat, sectarg[1]);
				break;
			case 'o':
				NAT_SET(nat_xorg, nat, sectarg[0]);
				NAT_SET(nat_yorg, nat, sectarg[1]);
				break;
			case 's':
				NAT_SET(nat_stat, nat, intarg); break;
			case 'd':
				NAT_SET(nat_dayno, nat, intarg); break;
			case 'u':
				NAT_SET(nat_minused, nat, intarg); break;
			case 'L':
				NAT_SET(nat_date, nat, intarg); break;
			case 'T':
				NAT_SETARY(nat_level[0], nat, NAT_TLEV, farg);
				break;
			case 'R':
				NAT_SETARY(nat_level[0], nat, NAT_RLEV, farg);
				break;
			case 'E':
				NAT_SETARY(nat_level[0], nat, NAT_ELEV, farg);
				break;
			case 'H':
				NAT_SETARY(nat_level[0], nat, NAT_HLEV, farg);
				break;
			default:
				pr(fmt("huh? (%c)\n",com));
				break;
			}
		}
	}
			
	case 'p':
	case 's':
	case 'n':
		pr("Not implemented yet.\n");
		return 0;

	default:
		pr("huh?\n");
		return RET_SYN;
	}
}

static
benifit(who, good) 
	int who;
	int good;
{
	if (good) 
		nreport(cnum, N_AIDS, who, 1);
	else
		nreport(cnum, N_HURTS, who, 1);
}

static
modsct1(public,beni,name,amt,sv) 
	int public;
	int beni;
	char *name;
	int amt;
	u_char *sv;
{
	extern	struct sctstr sect;

	if (*sv == amt) return;

	noise(public,beni,name,*sv,amt);

	*sv = amt;
	putsect(sect.sct_x, sect.sct_y);
}

static
modsct2(public,beni,name,amt,v) 
	char *name;
	int amt;
	int v;
{
	int olda = gsctv(v);
	psctv(v,amt);
	putsect(sect.sct_x, sect.sct_y);

	noise(public,beni,name,v,amt);
}

static
noise(public, beni, name, amt, namt)
	int public, beni;
	char *name;
	int amt, namt;
{
	extern	int cnum;

	if (public) 
	    wu(0, sect.sct_own, 
		fmt("%s in %s was changed from %d to %d by an act of %s",
		    name, ownxy(&sect), amt, namt, cname(cnum)));
	else
	    wu(0, sect.sct_own,
		fmt("%s in %s was %s by an act of %s",
		    name, ownxy(&sect),
		    amt < namt ? "increased" : "decreased", cname(cnum)));

	pr(fmt("%s in %d,%d changed from %d to %d\n", name, sect.sct_x,
		sect.sct_y,amt,namt));
	benifit ((int)sect.sct_own, beni ? namt > amt : namt < amt);
}

static
prsct() 
{
	pr(fmt("%3d,%-3d %c%c %2d %2d %3d %3d %3d %3d %3d %3d %3d %3d %3d %4d %1d\n",
		sect.sct_x, sect.sct_y, 
		dchr[sect.sct_type].d_mnem,
		(sect.sct_newtype == sect.sct_type) ? ' ' :
			 dchr[sect.sct_newtype].d_mnem,
		sect.sct_own, sect.sct_oldown,
		sect.sct_effic,
		sect.sct_mobil,
		sect.sct_min, sect.sct_gmin,
		sect.sct_fertil, sect.sct_oil, sect.sct_uran,
		sect.sct_work, sect.sct_loyal,
		gsctv(V_CHE),
		gsctv(V_PSTAGE)));
}

#include "../sailio.h"

static
prnat(n) 
	int n;
{
	struct natstr *np;
	extern int locks;
	extern SAIL *iop;

	np = getnat(n);
	/*
	 * either choice will flush buffer to tm, and then
	 * get updated nat entries (among other things)
	 */
	if (locks) {
		tm_unlock(iop, locks);
		locks = 0;
	} else {
		sflush(iop);
		tm_update(iop, -1);
	}

	pr(fmt("Country #: %2d ", n));
	pr(fmt("Name <n>: %-20s ", np->nat_cnam)); 
	pr(fmt("BTUs <b>: %3d ", np->nat_btu));
	pr(fmt("Flags <f>: %3x\n", np->nat_flags));
	pr(fmt("Representative <r>: %-20s ", np->nat_pnam));
	pr(fmt("Reserves <m>: %5d ", np->nat_reserve));
	pr(fmt("logged in <l>: %d\n", np->nat_login));
	pr(fmt("Telegrams <T>: %3d ", np->nat_tgms));
	pr(fmt("Capital <c>: %3d,%-3d ", np->nat_xcap, np->nat_ycap));
	pr(fmt("Origin <o>: %3d,%-3d ", np->nat_xorg, np->nat_yorg));
	pr(fmt("Status <s>: %x\n", np->nat_stat));
	pr(fmt("Day No <d>: %d ", np->nat_dayno));
	pr(fmt("Min Used <u>: %3d ", np->nat_minused));
	pr(fmt("Logoff <L>: %d ", np->nat_date));
	pr(fmt("Money: $%6d\n ", np->nat_money));
	pr(fmt("Technology <T>: %.1f ", np->nat_level[NAT_TLEV]));
	pr(fmt("Research <R>: %.1f\n", np->nat_level[NAT_RLEV]));
	pr(fmt("Education <E>: %.2f ", np->nat_level[NAT_ELEV]));
	pr(fmt("Happiness <H>: %.2f\n", np->nat_level[NAT_HLEV]));
}

