static char *RCSid = "$Header: dist.c 1.7 89/03/17 $";

/*
 * dist.c
 *
 * name distribution sector (by a pathname) for a given
 * range of sectors (individually)
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nsc.h"
#include "news.h"

/*
 * distribute <SECTS> <PATH>
 */
dist()
{
	extern	char *masktopath();
	extern	char *getstarg();
	extern	char *index();
	extern	char *fmt();
	extern	float pathtoxy();
	extern	float mcost();
	extern	char *argp[];
	extern	int cnum;
	extern	int owner;
	extern	struct sctstr sect;
	extern	struct dchrstr dchr[];
	struct	nstr nstr;
	char	*path;
	int	dstx;
	int	dsty;

	if (snxtsct(&nstr, argp[1]) == -1)
		return 2;
	if (argp[2] != 0) {
		/*
		**  Don't allow specifying a path over a range of
		**  sectors, since this will almost always be a mistake.
		*/
		if (index(argp[1], ',') == 0 || index(argp[1], ':') != 0) {
			pr("It's too dangerous to do that!\n");
			return 2;
		}
	}
	while (nxtsct(&nstr, 0)) {
		if (!owner)
			continue;
		path = masktopath(sect.sct_distpath);
		pr(fmt("%s at %d,%d ", dchr[sect.sct_type].d_name,
			nstr.n_x, nstr.n_y));
		if (path != 0) {
			dstx = nstr.n_x;
			dsty = nstr.n_y;
			(void) pathtoxy(path, &dstx, &dsty, mcost);
			getsect(dstx, dsty);
			if (sect.sct_own != cnum)
				pr(fmt("distributes to %d,%d, not owned by you. ",
					dstx, dsty));
			else
				pr(fmt("distributes to %d,%d. ", dstx, dsty));
		} else
			pr("has no dist sector. ");
		path = getstarg(argp[2], "New path? ");
		if (*path == 0)
			continue;
		if (strlen(path) > 10) {
			pr("Path too long!\n");
			continue;
		}
		if (chkpath(cnum, path, nstr.n_x, nstr.n_y) == 0)
			pr("Warning: dist path not fully yours\n");
		dstx = nstr.n_x;
		dsty = nstr.n_y;
		(void) pathtoxy(path, &dstx, &dsty, mcost);
		pr(fmt("New path distributes to %d,%d\n", dstx, dsty));
		getsect(dstx, dsty);
		if (sect.sct_own == cnum && sect.sct_type != SCT_WAREH)
			pr(fmt("Warning: sector %d,%d not a warehouse!\n",
				dstx, dsty));
		getsect(nstr.n_x, nstr.n_y);
		sect.sct_distpath = pathtomask(path);
		putsect(nstr.n_x, nstr.n_y);
	}
	return 0;
}
