static char *RCSid = "$Header: diss.c 1.5 89/03/17 $";

/*
 * diss.c
 *
 * perhaps the least-used command in empire!
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"
#include "nat.h"
#include "loan.h"
#include "treaty.h"
#include "news.h"

diss()
{
	extern	char *getstarg();
	extern	char *fmt();
	extern	char *mailbox();
	extern	char *argp[];
	extern	struct shpstr ship;
	extern	struct sctstr sect;
	extern	struct natstr *natp;
	extern	struct trtstr trty;
	extern	struct lonstr loan;
	extern	struct mchrstr mchr[];
	extern	struct plchrstr plchr[];
	extern	int w_xsize, w_ysize;
	extern	int cnum;
	extern	int nstat;
	register int r11;
	register int r10;
	struct	plnstr plane;
	int	f8;
	int	fc;
	int	f4;
	int	off;

/* #define NODISSOLVE */

	if (*getstarg(argp[1], "Are you SURE you want to do this? ") != 'y')
		return 0;
#ifdef NODISSOLVE

	getnat(cnum);
	NAT_SET(nat_pnam[0], cnum, "notgoneyet");
	close (0);
	return 0;

#else NODISSOLVE

	for (f8 = 0, r10 = 0; r10 < w_ysize; r10++) {
		for (r11 = 0; r11 < w_xsize; r11++) {
			if ((r10 + r11) & 01)
				continue;
			off = sctoff(r11, r10);
			if (sctown(off) != cnum)
				continue;
			getsect(r11, r10);
			if (sect.sct_own != cnum)
				continue;
			fc = gsctv(V_MILIT);
			f4 = gsctv(V_CIVIL) + fc;
			fc = (rand() % 1999);
			f4 /= fc;
			if (f4 <= 32) {
				pr(fmt("Rioting breaks out in %d,%d\n",
					r11, r10));
				sectdamage(r11, r10, f4);
				f8++;
			} else {
				pr(fmt("Populace unmoved in %d,%d\n",
					r11, r10));
			}
			setown(off, cnum, 0, 1);
			sect.sct_own = 0;
			putsect(r11, r10);
		}
	}
	if (f8 > 0)
		nreport(cnum, N_RIOT, 0, f8);
	f8 = 0;
	for (r11 = 0; getship(r11, &ship) == 0; r11++) {
		if (ship.shp_own != cnum)
			continue;
		pr(fmt("%s #%d ", mchr[ship.shp_type].m_name, r11));
		switch ((rand() >> 4) % 4) {
		case 0:
			pr("scuttled!\n");
			ship.shp_own = 0;
			break;
		case 1:
			pr("abandoned!\n");
			pshpv(V_CIVIL, 0, &ship);
			pshpv(V_MILIT, 0, &ship);
			break;
		case 2:
#ifdef notdef
			/*
			 * do this later after trade has been sub-routineized
			 */
			pr(fmt("has turned mercenary (for sale at $%d)\n",
				mchr[ship.shp_type].m_cost));
			/* set ship on sale */
			break;
#endif
		case 3:
			r10 = (rand() % 80) + 10;
			pr(fmt("crew has rioted! (%d%% damage)\n", r10));
			shipdamage(&ship, r10);
			f8++;
			break;
		}
		putship(r11, &ship);
	}
	if (f8 > 0)
		nreport(cnum, N_RIOT, 0, f8);
	for (r11 = 0; getplane(r11, &plane) == 0; r11++) {
		if (plane.pln_own != cnum)
			continue;
		pr(fmt("%s #%d ", plchr[plane.pln_type].pl_name, r11));
		switch ((rand() >> 4) % 3) {
		case 0:
			pr("blown up!\n");
			plane.pln_own = 0;
			break;
		case 1:
#ifdef notdef
			/*
			 * do this later after trade has been sub-routineized
			 */
			pr(fmt("has turned mercenary (for sale at $%d)\n",
				mchr[plane.shp_type].m_cost));
			/* set ship on sale */
			break;
#endif
		case 2:
			r10 = (rand() % 80) + 10;
			pr(fmt("crew has rioted! (%d%% damage)\n", r10));
			plane.pln_effic -= r10;
			f8++;
			break;
		}
		putplane(r11, &plane);
	}
	for (r11 = 0; gettre(r11) == 0; r11++) {
		if (trty.trt_cna != cnum && trty.trt_cnb != cnum)
			continue;
		r10 = trty.trt_cna == cnum ? trty.trt_cnb : trty.trt_cna;
		pr(fmt("No more treaty with %s\n", cname(r10)));
		wu(0, r10, fmt("Treaty #%d with %s voided", r11, cname(cnum)));
		trty.trt_cna = 0;
		trty.trt_cnb = 0;
		puttre(r11);
	}
	for (r11 = 0; getloan(r11) == 0; r11++) {
		if (loan.l_loner != cnum && loan.l_lonee != cnum)
			continue;
		if (loan.l_loner == cnum) {
			pr(fmt("Loan #%d to %s will never be repaid\n",
				r11, cname(loan.l_lonee)));
			wu(0, loan.l_lonee,
				fmt("Loan #%d from %s has been voided\n",
					r11, cname(cnum)));
		} else {
			pr(fmt("Loan #%d from %s will never be repaid\n",
				r11, cname(loan.l_lonee)));
			wu(0, loan.l_loner,
				fmt("Loan #%d to %s has been voided\n",
				r11, cname(cnum)));
		}
		loan.l_lonee = 0;
		loan.l_loner = 0;
		putloan(r11);
	}
	(void) close(creat(mailbox(cnum), 0660));
	getnat(cnum);
	NAT_DELTA(nat_stat, cnum, -STAT_NORM);
	nstat = STAT_VIS;
	nreport(cnum, N_DISS_GOV, 0, 1);
	return 0;
#endif NODISSOLVE
}
