static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/desi.c,v 1.9 89/05/10 01:56:29 muir Exp $";

/*
 * desi.c
 *
 * redesignate sectors
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "xy.h"
#include "path.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "nat.h"

desi()
{
	extern	char *argp[];
	register int n;
	char	*p;
	int	des;
	int	breaksanct;
	int	sanct_x;
	int	sanct_y;
	struct	nstr_sect nstr;
	struct	sctstr sect;
	struct	sctstr check;

	breaksanct = 0;
	if (snxtsct(&nstr, argp[1]) < 0)
		return RET_SYN;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (!god) {
			if (sect.sct_type == SCT_MOUNT ||
			    sect.sct_type == SCT_BSPAN ||
			    sect.sct_type == SCT_WASTE)
				continue;
		}
		p = fmt("%s %d%% %s  desig? ", ownxy(&sect),
			sect.sct_effic, dchr[sect.sct_type].d_name);
		if ((p = getstarg(argp[2], p)) == 0)
			continue;
		des = typematch(p, EF_SECTOR);
		if (des < 0 || (des == SCT_BSPAN && !god)) {
			pr("See \"info sector-types\"\n");
			continue;
		}
		if (!god) {
			if (des == SCT_WATER || des == SCT_MOUNT ||
			    des == SCT_SANCT) {
				pr(fmt("Only %s can make a %s!\n", cname(0),
					dchr[des].d_name));
				continue;
			}
			if (des == SCT_WASTE) {
				pr(fmt("Only a nuclear device (or %s) can make a %s!\n",
					cname(0), dchr[des].d_name));
				continue;
			}
		}
		if (sect.sct_type == des && sect.sct_newtype == des)
			continue;
		if (sect.sct_type == SCT_SANCT) {
			breaksanct++;
			sanct_x = nstr.x;
			sanct_y = nstr.y;
		}
		if (nstr.x == 0 && nstr.y == 0 && des != SCT_CAPIT &&
		    des != SCT_SANCT)
			pr("You have redesignated your capitol!\n");
		if (des == SCT_HARBR) {
			for (n = 1; n <= 6; n++) {
				getsect(nstr.x + diroff[n][0],
					nstr.y + diroff[n][1], &check);
				if (check.sct_type == SCT_WATER)
					break;
			}
			if (n > 6) {
				pr(fmt("%d,%d does not border on water.\n",
					nstr.x, nstr.y));
				if (god)
					pr("But if it's what you want ...\n");
				else
					continue;
			}
		}
		if (sect.sct_type == SCT_SANCT && !god)
			continue;
		n = sect.sct_type;
		if (sect.sct_effic < 5 || god) {
			sect.sct_type = des;
			sect.sct_effic = 0;
		}
		sect.sct_newtype = des;
		putsect(&sect);
		if (n != SCT_BHEAD)
			continue;
		bridgefall(&sect);
	}
	if (breaksanct)
		bsanct(sanct_x, sanct_y);
	return 0;
}
