static char *RCSid = "$Header: conv.c 1.6 89/03/17 $";

/*
 * conv.c
 *
 * Convert conquered populace into uw's.
 *
 * Pay $1.5 per civ converted (reg fees), as well as 1 btu/100
 * in paper shuffling.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nsc.h"
#include "news.h"

conv()
{
	extern	char *fmt();
	extern	char *getstarg();
	extern	char *argp[];
	extern	double dolcost;
	extern	struct sctstr sect;
	extern	struct natstr *natp;
	extern	int btused;
	extern	int owner;
	extern	int cnum;
	extern	int god;
	extern	int owner;
	register int uw_want;
	register int newuw;
	int	civ;
	int	mil;
	int	uw;
	int	totaluw;
	struct	nstr nstr;
	int	mob;

	if (snxtsct(&nstr, argp[1]) == -1)
		return 2;
	getnat(cnum);
	uw_want = atoi(getstarg(argp[2], "Number to convert : "));
	totaluw = 0;
	while (nxtsct(&nstr, 0)) {
		if (!owner)
			continue;
		if (sect.sct_oldown == cnum)
			continue;
		civ = gsctv(V_CIVIL);
		if (civ == 0)
			continue;
		mil = gsctv(V_MILIT);
		/*
		 * Must have military control to convert captured civs.
		 */
		if (mil * 10 < civ)
			continue;
		newuw = civ;
		if (uw_want <= 0) {
			/*
			 * convert up to uw_want # of civilians.
			 */
			if (newuw > -uw_want - civ)
				newuw = -uw_want - civ;
			if (newuw > 500)
				newuw = 500;
		} else if (newuw > uw_want)
			newuw = uw_want;
		uw = gsctv(V_UW);
		if (newuw > 999 - uw)
			newuw = 999 - uw;
		if (newuw <= 0)
			continue;
		/*
		 * So entire civilian populations don't disappear immediately
		 * into slave camps, charge a healthy mobility cost for conversions.
		 */
		mob = sect.sct_mobil * 5;
		if (mob <= 0)
			continue;
		if (mob < newuw)
			newuw = mob;
		if (newuw < mob)
			mob = newuw;
		if (psctv(V_UW, newuw + uw) < 0) {
			pr(fmt("No room for new uw in %d,%d\n",
				nstr.n_x, nstr.n_y));
			continue;
		}
		psctv(V_CIVIL, civ - newuw);
		sect.sct_mobil -= mob / 5;
		pr(fmt("%3d conquered civilians converted in %d,%d (%d)\n",
			newuw, nstr.n_x, nstr.n_y, uw + newuw));
		if (civ - newuw == 0) {
			sect.sct_oldown = sect.sct_own;
			pr(fmt("%d,%d is now completely yours.\n",
				sect.sct_x, sect.sct_y));
		}
		putsect(nstr.n_x, nstr.n_y);
		btused += (newuw / 100) + 1;
		dolcost += (newuw * 1.5);
		totaluw += newuw;
	}
	pr(fmt("Total civilians converted : %d\n", totaluw));
	pr(fmt("Paperwork at conversion places ... %d\n", btused));
	return 0;
}
