static char *RCSid = "$Header: coll.c 1.5 89/03/17 $";

/*
 * coll.c
 *
 * collect on loan
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "loan.h"
#include "news.h"

coll()
{
	extern	char *fmt();
	extern	char *argp[];
	extern	struct lonstr loan;
	extern	int sx, sy;
	extern	struct dchrstr dchr[];
	extern	struct ichrstr ichr[];
	extern	struct sctstr sect;
	extern	int cnum;
	register char *cp;
	register int arg;
	register int i;
	register int val;
	long	now;
	long	due;
	long	last;
	long	rdur;
	long	xdur;
	double	rate;
	double	owed;
	double	pay;

	if ((arg = onearg(argp[1], "Collect on loan #")) < 0)
		return 2;
	if (getloan(arg) == -1 || loan.l_loner != cnum || loan.l_ldur == 0) {
		pr("You aren't owed anything on that loan...\n");
		return 1;
	}
	(void) time(&now);
	due = loan.l_duedate;
	if (now <= due) {
		pr(fmt("There has been no default on loan %d\n", arg));
		return 1;
	}
	last = loan.l_lastpay;
	if (last < due && due < now) {
		rdur = due - last;
		xdur = now - due;
	}
	if (due < last) {
		rdur = 0;
		xdur = now - last;
	}
	rate = loan.l_irate / (loan.l_ldur * 8.64e6);
	owed = ((rdur * rate) + (xdur * rate * 2.0) + 1.0) * loan.l_amtdue;
	pr(fmt("You are owed $%.2f on that loan.\n", owed));
	if (getsno(argp[2], "What sector do you wish to confiscate? ") == -1)
		return RET_SYN;
	if (neigh(sx, sy, cnum) == -1) {
		pr(fmt("You are not adjacent to %d,%d", sx, sy));
		return RET_OK;
	}
	if (sect.sct_own != loan.l_lonee) {
		pr(fmt("%d,%d is not owned by %s.\n",
			sx, sy, cname(loan.l_lonee)));
		return RET_OK;
	}
	pay = dchr[sect.sct_type].d_value * ((float)sect.sct_effic + 100.0);
	for (i = 0; ichr[i].i_name != 0; i++) {
		if (ichr[i].i_value == 0)
			continue;
		if (ichr[i].i_vtype == 0) {
			cp = (char *) (&sect) + i;
			val = *cp;
		} else {
			val = gsctv(ichr[i].i_vtype);
		}
		if (val == 0)
			continue;
		pay += val * ichr[i].i_value;
	}
	sigsave();
	pr(fmt("That sector (and its contents) is valued at $%.2f\n", pay));
	if (pay > owed * 1.2) {
		sigrest();
		return RET_OK;
	}
	if (sect.sct_type == SCT_CAPIT)
		caploss(sx, sy, sect.sct_own, "that was %s's capital!\n");
	psctv(V_MILIT, 0);
	takeover(&sect, 0);
	putsect(sx, sy);
	nreport(cnum, N_SEIZE_SECT, loan.l_lonee, 1);
	if (pay > owed) {
		loan.l_ldur = 0;
		nreport(loan.l_lonee, N_REPAY_LOAN, cnum, 1);
		wu(0, loan.l_lonee,
			fmt("Country %d seized %d,%d to satisfy loan #%d\n",
				cnum, sx, sy, arg));
		pr("That loan is now considered repaid.\n");
	} else {
		(void) time(&loan.l_lastpay);
		owed -= pay;
		loan.l_amtdue = owed;
		pay += loan.l_amtpaid;
		loan.l_amtpaid = pay;
		wu(0, loan.l_lonee, 
			fmt("Country %d seized %d,%d in partial payment of loan %d.\n", cnum, xwrap(sx-orgxof(loan.l_lonee)+orgxof(cnum)), ywrap(sy-orgyof(loan.l_lonee)+orgyof(cnum)), arg));
		pr(fmt("You are still owed $%.2f on loan %d.\n", owed, arg));
	}
	putloan(arg);
	sigrest();
	return RET_OK;
}
