static char *RCSid = "$Header: coas.c 1.5 89/03/17 $";

/*
 * coas.c
 *
 * look at all ships in world.
 *
 * Keith Muller, 1983
 * and Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "nsc.h"

#define	TSIZE	200

struct coast {
	struct coast *c_next;
	int c_spotted;
	int c_number;
	struct shpstr c_shp;
};

/*
 * coastwatch: coastwatch [SECTS]
 *
 * leaving the first arg blank will default to the
 * entire world.
 */
coas() {
	extern	char *alloca();
	extern	double tfact();
	extern	char *fmt();
	extern	int cnum;
	extern	char *argp[];
	extern	struct mchrstr mchr[];
	extern	int cnum;
	extern	struct sctstr sect;
	register struct coast *cp;
	register int i;
	register int k;
	register int j;
	struct	coast *list[TSIZE];
	struct	nstr nstr;
	int	n;
	float	tech;
	int	vrange;
	int	x;
	int	y;
	int	mink;
	int	minj;
	int	maxk;
	int	see;
	int	maxj;

	if (snxtsct(&nstr, argp[1]) < 0)
		return RET_SYN;
	for (i=0; i<TSIZE; i++)
		list[i] = 0;
	cp = (struct coast *) alloca(sizeof(struct coast));
	for (i=0; getship(i, &cp->c_shp) == 0; i++) {
		if (cp->c_shp.shp_own == 0 || cp->c_shp.shp_own == cnum)
			continue;
		/*
		 * don't bother putting subs in the table...
		 */
		if (mchr[cp->c_shp.shp_type].m_visib <= 2)
			continue;
		n = scthash(cp->c_shp.shp_x, cp->c_shp.shp_y, TSIZE);
		cp->c_spotted = 0;
		cp->c_number = i;
		cp->c_next = list[n];
		list[n] = cp;
		cp = (struct coast *) alloca(sizeof(struct coast));
	}
	pr(fmt("- = [ Coastwatch report for %s ] = -\n", cname(cnum)));
	pr(fmt("  Country           Ship          Location\n"));
	tech = tfact(cnum, 1.0);
	while (nxtsct(&nstr, 0)) {
		see = sect.sct_type == SCT_RADAR ? 6 : 3;
		if (sect.sct_own != cnum)
			continue;
		vrange = sect.sct_effic / 100.0 * see * tech;
		if (vrange < 1)
			vrange = 1;
		maxk = vrange;
		maxj = vrange*2;
		vrange *= vrange;
		mink = -maxk;
		minj = -maxj;
		for (j=minj; j <= maxj; j++) {
			for (k=mink; k <= maxk; k++) {
				if ((j + k) & 01)
					 continue;
				/*
				 * faster to range-find than to x/ywrap+hash
				 */
				if (vrange < (j*j + 3*k*k)/4)
					continue;
				x = xwrap(sect.sct_x + j);
				y = ywrap(sect.sct_y + k);
				n = scthash(x, y, TSIZE);
				if (list[n] == 0)
					continue;
				showship(&list[n], x, y);
			}
		}
	}
	return RET_OK;
}

showship(cpp, x, y)
	struct	coast **cpp;
	int	x;
	int	y;
{
	register struct coast *cp;
	register struct coast **prev;
	register struct mchrstr *mcp;
	char	*name;

	prev = 0;
	cp = *cpp;
	prev = cpp;
	do {
		if (cp->c_shp.shp_x != x || cp->c_shp.shp_y != y) {
			prev = &(*prev)->c_next;
			continue;
		}
		mcp = &mchr[cp->c_shp.shp_type];
		if (mcp->m_flags & M_FOOD)
			name = "fishing vessel";
		else
			name = mcp->m_name;
		pr(fmt(" %12.12s (#%2d) %s #%d @ %d,%d\n",
			cname(cp->c_shp.shp_own), cp->c_shp.shp_own,
			name, cp->c_number, x, y));
		*prev = cp->c_next;
	} while (cp = cp->c_next);
}
