static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/cens.c,v 1.11 89/05/10 01:56:12 muir Exp $";

/*
 * cens.c
 *
 * do a census report
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "path.h"
#include "file.h"

cens()
{
	extern	char *argp[];
	struct	sctstr sect;
	int	nsect;
	int	n;
	struct	nstr_sect nstr;
	char	dirstr[20];
	int	vec[I_MAX+1];

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	prdate();
	strcpy(&dirstr[1], dirch);
	dirstr[0] = '.';
	dirstr[7] = '$';
	dirstr[8] = '\0';
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (nsect++ == 0)
			cens_hdr();
		if (god)
			pr(fmt("%2d ", sect.sct_own));
		pr(fmt("%-7.7s %c", xyas(nstr.x, nstr.y, cnum),
			dchr[sect.sct_type].d_mnem));
		if (sect.sct_newtype != sect.sct_type)
			pr(fmt("%c", dchr[sect.sct_newtype].d_mnem));
		else
			pr(" ");
		pr(fmt("%4d%%", sect.sct_effic));
		pr(fmt("%4d", sect.sct_mobil));

		getvec(VT_DEL, (char *)&sect, EF_SECTOR, vec);
		pr(fmt("  %c", dirstr[vec[I_UW] & 0x7]));
		pr(fmt("%c", dirstr[vec[I_FOOD] & 0x7]));

		getvec(VT_DIST, (char *)&sect, EF_SECTOR, vec);
		n = vec[I_UW] % 1000;
		pr(fmt("  %c", n == 0 ? '.' : '0'+ (n/100)));
		n = vec[I_FOOD] % 1000;
		pr(fmt("%c ", n == 0 ? '.' : '0'+ (n/100)));
		pr(fmt("%c", sect.sct_own != sect.sct_oldown ? '*' : ' '));

		getvec(VT_ITEM, (char *)&sect, EF_SECTOR, vec);
		pr(fmt("%4d", vec[I_CIVIL]));
		pr(fmt("%4d", vec[I_MILIT]));
		pr(fmt("%4d", vec[I_UW]));
		pr(fmt("%6d", vec[I_FOOD]));
		pr(fmt("%5d", sect.sct_min));
		pr(fmt("%5d", sect.sct_gmin));
		pr(fmt("%5d", sect.sct_fertil));
		pr(fmt("%4d", sect.sct_oil));
		pr(fmt("%5d", sect.sct_uran));
		pr(fmt("%4d%%\n", sect.sct_work));
	}
	pr(fmt("    %d sector%s\n", nsect, splur(nsect)));
	return 0;
}

cens_hdr()
{
	if (god)
		pr("   ");
	pr("CENSUS              del dst\n");
	if (god)
		pr("own");
	pr("  sect      eff mob  uf  uf   civ mil  uw  food  min gold fert oil uran work\n");
}
