static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/buil.c,v 1.17 89/05/10 01:55:52 muir Exp $";

/*
 * buil.c
 *
 * version 3.0
 * build ships, nukes, bridges, planes.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "ship.h"
#include "nuke.h"
#include "plane.h"
#include "xy.h"
#include "nsc.h"
#include "treaty.h"
#include "deity.h"
#include "file.h"
#include "path.h"

static	int cash;

/*
 * build <WHAT> <SECTS> <TYPE|DIR|MEG>
 */
buil()
{
	extern	char *argp[];
	extern  double buil_bt, buil_bc;
	extern  int buil_bh;
	extern	double dolcost;
	struct	sctstr sect;
	struct	nstr_sect nstr;
	struct	natstr *natp;
	int	tlev;
	int	workforce;
	int	n;
	int	type;
	int	what;
	struct	mchrstr *mp;
	struct	plchrstr *pp;
	struct	nchrstr *np;
	char	*p;
	int	efftech;
	int	vec[I_MAX+1];

	natp = getnatp(cnum);
	tlev = god ? 999+(1<<26) : natp->nat_level[NAT_TLEV];
	cash = natp->nat_money;
	efftech = -1;
	p = getstarg(argp[1], "Build what (ship, nuke, bridge, plane)? ");
	if (p != 0)
		what = *p;
	else 
		what = '\0';
	if (!snxtsct(&nstr, argp[2]))
		return 2;
ask_again:
	switch (what) {
	case 'p':
		argp[3] = p = getstarg(argp[3], "plane type? ");
		if (p == 0 || *p == 0)
			return 2;
		n = strlen(p);
		for (type=0, pp = plchr; type <= pln_maxno; type++, pp++) {
			if (pp->pl_tech > tlev)
				continue;
			if (strncmp(p, pp->pl_name, n) == 0)
				break;
		}
		if (type > pln_maxno) {
			pr("Possible plane types are :\n");
			show_plane_build (tlev);
			argp[3] = 0;
			goto ask_again;
		}
		break;
	case 's':
		argp[3] = p = getstarg(argp[3], "Ship type? ");
		if (p == 0 || *p == 0)
			return 2;
		n = strlen(p);
		for (mp = mchr, type=0; type <= shp_maxno; type++, mp++) {
			if (mp->m_tech > tlev)
				continue;
			if (strncmp(p, mp->m_name, n) == 0)
				break;
		}
		if (type > shp_maxno) {
			pr("Possible ship types are :\n");
			show_ship_build (tlev);
			argp[3] = 0;
			goto ask_again;
		}
		break;
	case 'b':
		if (tlev < buil_bt) {
			pr(fmt("Building a span requires a tech of %.0f\n",
				buil_bt));
			return 2;
		}
		break;
	case 'n':
		argp[3] = p = getstarg(argp[3], "Nuke type? ");
		if (p == 0 || *p == 0)
			return 2;
		n = strlen(p);
		for (np = nchr, type=0; type <= nuk_maxno; type++, np++) {
			if (np->n_tech > tlev)
				continue;
			if (strncmp(p, np->n_name, n) == 0)
				break;
		}
		if (type > nuk_maxno) {
			pr("Possible nuke types are :\n");
			show_nuke_build (tlev);
			argp[3] = 0;
			goto ask_again;
		}
		break;
	default:
		pr("You can't build that!\n");
		return RET_FAIL;
	}
	if (what != 'b') {
		argp[4] = p = getstarg(argp[4], "Build at what tech? ");
		if (p != 0 && *p != '\0' && efftech < 0) {
			efftech = tlev = atopi(p);
			if (tlev > natp->nat_level[NAT_TLEV] && !god) {
				pr("Your tech isn't that high!\n");
				return 0;
			}
			pr(fmt("Effective tech level is %d\n", tlev));
			goto ask_again;
		}
	}
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (sect.sct_effic < 60 && !god)
			continue;
		getvec(VT_ITEM, &sect, EF_SECTOR, vec);
		workforce = vec[I_CIVIL] + vec[I_UW] + vec[I_MILIT] * 2 / 5;
		switch (what) {
		case 's':
			build_ship(&sect, mp, vec, workforce, tlev);
			break;
		case 'b':
			build_bridge(&sect, vec, workforce);
			break;
		case 'n':
			build_nuke(&sect, np, vec, workforce);
			break;
		case 'p':
			build_plane(&sect, pp, vec, workforce, tlev);
			break;
		default:
			pr(fmt("internal error in build (%d)\n", what));
			return RET_FAIL;
		}
	}
	return RET_OK;
}

int
build_ship(sp, mp, vec, workforce, tlev)
	register struct sctstr *sp;
	register struct mchrstr *mp;
	register int *vec;
	int	workforce;
	int	tlev;
{
	struct	shpstr ship;
	struct	nstr_item nstr;
	int	val;
	int	cost;

	if (sp->sct_type != SCT_HARBR)
		return 0;
	if (vec[I_LCM] < mp->m_lcm || vec[I_HCM] < mp->m_hcm) {
		pr(fmt("Not enough materials in %s\n", ownxy(sp)));
		return 0;
	}
	val = mp->m_lcm + (mp->m_hcm * 2);
	if (val > workforce) {
		pr(fmt("Not enough workforce in %s to build a %s\n",
			ownxy(sp), mp->m_name));
		return 0;
	}
	cost = mp->m_cost;
	if (cash < cost) {
		pr(fmt("Not enough money left to build a %s\n", mp->m_name));
		return 0;
	}
	if (trechk(cnum, 0, NEWSHP) == 0)
		return 0;
	dolcost += cost;
	cash -= cost;
	snxtitem_all(&nstr, EF_SHIP);
	while (nxtitem(&nstr, &ship))
		if (ship.shp_own == 0)
			break;
	ship.shp_x = sp->sct_x;
	ship.shp_y = sp->sct_y;
	ship.shp_own = cnum;
	ship.shp_type = mp - mchr;
	ship.shp_effic = 20;
	ship.shp_mobil = 0;
	ship.shp_uid = nstr.cur;
	ship.shp_nplane = 0;
	ship.shp_fleet = ' ';
	ship.shp_nv = 0;
	ship.shp_sell = 0;
	ship.shp_tech = tlev;
	if (getvar(V_PSTAGE, sp, EF_SECTOR) == PLG_INFECT)
		putvar(V_PSTAGE, PLG_EXPOSED, &ship, EF_SHIP);
	putship(nstr.cur, &ship);
	pr(fmt("%s #%d", mp->m_name, nstr.cur));
	pr(fmt(" built in sector %s\n", ownxy(sp)));
	putvar(V_LCM, vec[I_LCM] - mp->m_lcm, sp, EF_SECTOR);
	putvar(V_HCM, vec[I_LCM] - mp->m_hcm, sp, EF_SECTOR);
	vec[I_LCM] -= mp->m_lcm;
	vec[I_HCM] -= mp->m_hcm;
	putsect(sp);
	return 1;
}

build_bridge(sp, vec, workforce)
	register struct sctstr *sp;
	register int *vec;
	int	workforce;
{
	struct	sctstr sect;
	int	val;
	int	newx, newy;

	if (sp->sct_type != SCT_BHEAD)
		return 0;
	if (vec[I_HCM] < buil_bh) {
		pr(fmt("%s only has %d unit%s of hcm,\n", ownxy(sp),
			vec[I_HCM], vec[I_HCM] > 1 ? "s" : ""));
		pr(fmt("(a bridge span requires %d)\n", buil_bh));
		return 0;
	}
	if (cash < buil_bc) {
		pr(fmt("A span costs $%d to build; ", buil_bc));
		pr(fmt("you only have %d.\n", cash));
		return 0;
	}
	if (workforce < buil_bh * 2) {
		pr("Not enough workforce to build a bridge span in");
		pr(fmt(" %s (%d workers required).\n", ownxy(sp), buil_bh * 2));
		return 0;
	}
	pr(fmt("Bridge head at %s; ", ownxy(sp)));
	if ((val = getdir("build span in what direction? ", 0, 0, 0)) <= 0)
		return 0;
	newx = sp->sct_x + diroff[val][0];
	newy = sp->sct_y + diroff[val][1];
	if (getsect(newx, newy, &sect) == 0 || sect.sct_type != SCT_WATER) {
		pr(fmt("%s is not a water sector\n", ownxy(&sect)));
		return 0;
	}
	dolcost += buil_bc;
	cash -= buil_bc;
	sect.sct_type = SCT_BSPAN;
	sect.sct_newtype = SCT_BSPAN;
	sect.sct_effic = 20;
	putsect(&sect);
	putvar(V_HCM, vec[I_HCM] - buil_bh, sp, EF_SECTOR);
	vec[I_HCM] -= buil_bh;
	putsect(sp);
	pr(fmt("Bridge span built over %d,%d\n", ownxy(&sect)));
	return 1;
}

int
build_nuke(sp, np, vec, workforce)
	register struct sctstr *sp;
	register struct nchrstr *np;
	register int *vec;
	int	workforce;
{
	int	val;
	struct	nukstr nuke;
	struct	nstr_item nstr;
	int	old;
	int	free;

	if (sp->sct_type != SCT_NUKE && !god)
		return 0;
	if (vec[I_HCM] < np->n_hcm || vec[I_LCM] < np->n_lcm ||
	    vec[I_OIL] < np->n_oil || vec[I_RAD] < np->n_rad) {
		pr(fmt("Not enough materials for a %s bomb in %s\n",
			np->n_name, ownxy(sp)));
		pr(fmt("(%d hcm, %d lcm, %d oil, & %d rads).\n",
			np->n_hcm, np->n_lcm, np->n_oil, np->n_rad));
		return 0;
	}
	if (cash < np->n_cost) {
		pr(fmt("You need $%d, you only have %d.\n", np->n_cost, cash));
		return 0;
	}
	val = np->n_lcm + np->n_hcm * 2;
	if (workforce < val && !god) {
		pr(fmt("Not enough workforce to build nuke in %s", ownxy(sp)));
		pr(fmt(" (%d workers required).\n", val));
		return 0;
	}
	if (trechk(cnum, 0, NEWNUK) == 0)
		return 0;
	dolcost += np->n_cost;
	cash -= np->n_cost;
	snxtitem_all(&nstr, EF_NUKE);
	free = -1;
	while (old = nxtitem(&nstr, &nuke)) {
		if (nuke.nuk_own != cnum)
			continue;
		if (nuke.nuk_x == sp->sct_x || nuke.nuk_y == sp->sct_y) {
			val = nstr.cur;
			break;
		}
		if (nuke.nuk_own == 0 && free < 0)
			free = nstr.cur;
	}
	if (old == 0) {
		if (free >= 0)
			val = free;
		else
			val = nstr.cur;
		getnuke(val, &nuke);
		bzero(&nuke, sizeof(nuke));
	} else
		getnuke(val, &nuke);
	if (nuke.nuk_own == 0) {
		nuke.nuk_x = sp->sct_x;
		nuke.nuk_y = sp->sct_y;
		nuke.nuk_n = 0;
		nuke.nuk_own = cnum;
		nuke.nuk_uid = val;
		nuke.nuk_ship = -1;
	}
	nuke.nuk_types[np - nchr]++;
	nuke.nuk_n++;
	putnuke(val, &nuke);
	putvar(V_HCM, vec[I_HCM] - np->n_hcm, sp, EF_SECTOR);
	putvar(V_LCM, vec[I_LCM] - np->n_lcm, sp, EF_SECTOR);
	putvar(V_OIL, vec[I_OIL] - np->n_oil, sp, EF_SECTOR);
	putvar(V_RAD, vec[I_RAD] - np->n_rad, sp, EF_SECTOR);
	vec[I_HCM] -= np->n_hcm;
	vec[I_LCM] -= np->n_lcm;
	vec[I_OIL] -= np->n_oil;
	vec[I_RAD] -= np->n_rad;
	putsect(sp);
	pr(fmt("%s warhead created in %s\n", np->n_name, ownxy(sp)));
	return 1;
}

build_plane(sp, pp, vec, workforce, tlev)
	register struct sctstr *sp;
	register struct plchrstr *pp;
	register int *vec;
	int	workforce;
	int	tlev;
{
	struct	plnstr plane;
	int	val;
	int	cost;
	int	n;
	struct	nstr_item nstr;

	if (sp->sct_type != SCT_AIRPT && !god)
		return 0;
	if (vec[I_LCM] < pp->pl_lcm || vec[I_HCM] < pp->pl_hcm) {
		pr(fmt("Not enough materials in %s\n", ownxy(sp)));
		return 0;
	}
	val = pp->pl_lcm + (pp->pl_hcm * 2);
	if (val > workforce) {
		pr(fmt("Not enough workforce in %s to build a %s\n",
			ownxy(sp), pp->pl_name));
		return 0;
	}
	cost = pp->pl_cost;
	if (cash < cost) {
		pr(fmt("Not enough money left to build a %s\n", pp->pl_name));
		return 0;
	}
	if (vec[I_MILIT] < pp->pl_crew) {
		pr(fmt("Not enough military for crew in %s\n", ownxy(sp)));
		return 0;
	}
	if (trechk(cnum, 0, NEWPLN) == 0)
		return 0;
	dolcost += cost;
	cash -= cost;
	snxtitem_all(&nstr, EF_PLANE);
	while (nxtitem(&nstr, &plane))
		if (plane.pln_own == 0)
			break;
	plane.pln_x = sp->sct_x;
	plane.pln_y = sp->sct_y;
	plane.pln_own = sp->sct_own;
	plane.pln_type = pp - plchr;
	plane.pln_effic = 10;
	plane.pln_mobil = 0;
	n = pp->pl_range * (0.75 + techfact(tlev - pp->pl_tech, 2.0));
	if (n > 127)
		n = 127;
	plane.pln_range = n;
	n = pp->pl_att * (0.75 + techfact(tlev - pp->pl_tech, 2.0));
	if (n > 127)
		n = 127;
	plane.pln_att = n;
	n = pp->pl_def * (0.75 + techfact(tlev - pp->pl_tech, 2.0));
	if (n > 127)
		n = 127;
	plane.pln_def = n;
	plane.pln_wing = ' ';
	plane.pln_tech = tlev;
	plane.pln_ship = -1;
	plane.pln_uid = nstr.cur;
	plane.pln_nukeamt = 0;
	plane.pln_nuketype = 0;
	plane.pln_harden = 0;
	plane.pln_sell = 0;
	plane.pln_flags = 0;
	putplane(nstr.cur, &plane);
	pr(fmt("%s #%d built in sector %s\n", pp->pl_name, n, ownxy(sp)));
	putvar(V_LCM, vec[I_LCM] - pp->pl_lcm, sp, EF_SECTOR);
	putvar(V_HCM, vec[I_HCM] - pp->pl_hcm, sp, EF_SECTOR);
	putvar(V_MILIT, vec[I_MILIT] - pp->pl_crew, sp, EF_SECTOR);
	vec[I_LCM] -= pp->pl_lcm;
	vec[I_HCM] -= pp->pl_hcm;
	vec[I_MILIT] -= pp->pl_crew;
	putsect(sp);
	return 1;
}
