static char *RCSid = "$Header: assa.c 1.10 89/03/17 $";

/*
 * assa.c
 *
 * hit the beaches!
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "ship.h"
#include "sect.h"
#include "news.h"

assa()
{
	extern	double defdef();
	extern	double shipdef();
	extern	char *fmt();
	extern	struct mchrstr mchr[];
	extern	struct dchrstr dchr[];
	extern	char *argp[];
	extern	int lx;
	extern	int ly;
	extern	struct sctstr sect;
	extern	struct shpstr ship;
	extern	int btused;
	extern	int cnum;
	register int r11;
	register int r10;
	register int r9;
	int	f4;
	int	own;
	int	fc;
	int	f10;
	int	f14;
	int	f18;
	int	f1c;
	int	f20;
	int	a_mil;
	int	f28;
	double	f30;
	double	f38;
	double	f40;
	double	f48;
	double	f50;
	double	f58;

	if (sargs(argp[1]) < 0)
		return 2;
	if (getsect(lx, ly) < 0) {
		pr("Don't bother...\n");
		return 2;
	}
	own = sect.sct_own;
	f14 = lx;
	f18 = ly;
	f4 = getshno(argp[2],
		fmt("Assault sector %d, %d from ship #", f14, f18), &ship);
	if (f4 < 0 || ship.shp_own != cnum) {
		pr("Not yours.\n");
		return 2;
	}
	fc = ship.shp_x;
	f10 = ship.shp_y;
	if (mapdsq(fc, f10, f14, f18) > 1) {
		pr("You'll have to get there first...\n");
		return 1;
	}
	if (sect.sct_type <= SCT_WASTE) {
		pr("Don't bother...\n");
		return 1;
	}
	a_mil = gshpv(V_MILIT, &ship);
	if (a_mil == 0) {
		pr(fmt("No military on ship #%d", f4));
		return 1;
	}
	if (own && trechk(cnum, own, 4) < 0)
		return 1;
	r9 = wethr(f14, f18, 0);
	if (r9 < 730) {
		pr(fmt("Barometer @%d; Seas too rough to assault...\n", r9));
		return 1;
	}
	if (sect.sct_own == cnum) {
		pr("That's your own sector!\n");
		return 1;
	}
	if (sctdes(sctoff(fc, f10)) != SCT_WATER) {
		pr("Your ship is not in the water!\n");
		return 0;
	}
	f28 = gsctv(V_MILIT);
	pr(fmt("Sector %d, %d is a %d%% %s with approx. %d military.\n",
		f14, f18, round(sect.sct_effic, 10),
		dchr[sect.sct_type].d_name,
		round(f28, 10)));
	if (f28 && (mchr[ship.shp_type].m_flags & M_LAND) == 0)
		a_mil = a_mil > 0 ? (a_mil / 10) + 1 : 0;
	r11 = onearg(argp[3],fmt("Number of troops in assault? (max %d) ",
		a_mil));
	r11 = min(r11, a_mil);
	if (r11 == 0)
		return 1;
	sigsave();
	/*
	 * NOTE: need getcom here
	 */
	f58 = gshpv(V_FOOD, &ship);
	f48 = f58 * r11 / (gshpv(V_MILIT, &ship) + gshpv(V_CIVIL, &ship)) + 0.5;
	pshpv(V_MILIT, gshpv(V_MILIT, &ship) - r11, &ship);
	r9 = f58 - f48;
	pshpv(V_FOOD, r9, &ship);
	f48 /= (double) r11;
	putship(f4, &ship);
	f40 = (dchr[sect.sct_type].d_dstr / 2.0 - 1.0) *
		(sect.sct_effic / 100.0) + 1.0;
	r10 = f28 * f40;
	f50 = (double) r11 / (r10 * 2 + r11);
	pr(fmt("Your success odds are %.1f%%\n", f50 * 100.0));
	f1c = seadef(ship.shp_type);
	f38 = 0.0;
	f30 = f38;
	f20 = fortdef(f14, f18, f1c, fc, f10);
	if (f20 > 0) {
		shipdamage(&ship, f20);
		putship(f4, &ship);
		if (ship.shp_own == 0)
			goto lostship;
		r11 = ((100 - f20) * r11) / 100.0 + 0.5;
		f50 = (double) r11 / (r10 * 2 + r11);
		pr(fmt("Your success odds are now %.1f%%\n", f50 * 100.0));
	}
	f20 = defdef(f14, f18, f1c, fc, f10);
	if (f20 > 0) {
		shipdamage(&ship, f20);
		putship(f4, &ship);
		if (ship.shp_own == 0)
			goto lostship;
		r11 = ((100 - f20) * r11) / 100.0 + 0.5;
		f50 = (double) r11 / (r10 * 2 + r11);
		pr(fmt("Your success odds are now %.1f%%\n", f50 * 100.0));
	}
	f20 = shipdef(own, f1c, fc, f10);
	if (f20 > 0) {
		wu(0, own, fmt("Return fire did %d%% damage to %s #%d",
			f20, mchr[ship.shp_type].m_name, f4));
		shipdamage(&ship, f20);
		putship(f4, &ship);
		if (ship.shp_own == 0)
			goto lostship;
		r11 = ((100 - f20) * r11) / 100.0 + 0.5;
		f50 = (double) r11 / (r10 * 2 + r11);
		pr(fmt("Your success odds are now %.1f%%\n", f50 * 100.0));
	}
	if (r11 == 0) {
lostship:
		wu(0, own, fmt("Country #%d lost %s #%d trying to assault %s",
			cnum, mchr[ship.shp_type].m_name, f4,
			xytoa(f14, f18, own)));
		nreport(cnum, N_SHP_LOSE, own, 1);
		return 0;
	}
	getsect(f14, f18);
	while (r10 > 0) {
		if (r11 <= 0)
			break;
		if (chance(f50) == 0) {
			pr("@");
			f38 += 1.0;
			r11--;
		} else {
			pr("!");
			f30 += 1.0 / f40;
			r10--;
		}
	}
	if (own)
		wu(0, own, fmt("Country #%d assaulted you @%s", cnum,
			xytoa(f14, f18, own)));
	if (r11 > r10) {
		pr(fmt("You have taken sector %d, %d\n", f14, f18));
		if (own)
			wu(0, own, fmt("& lost %.1f taking %s\n", f38,
				xytoa(f14, f18, own)));
		nreport(cnum, N_WON_SECT, own, 1);
		r11 = takeover(&sect, r11);
		sect.sct_mobil = 0;
		psctv(V_MILIT, r11);
		f58 = gsctv(V_FOOD);
		r9 = r11 * f48 + f58;
		psctv(V_FOOD, r9);
		psctv(V_CHKPT, 0);
		if (gshpv(V_PSTAGE, &ship) == PLG_INFECT)
			if (gsctv(V_PSTAGE) == 0)
				psctv(V_PSTAGE, PLG_EXPOSED);
		if (sect.sct_type == SCT_CAPIT)
			caploss(f14, f18, own,
				"which happens to be %s's capital!\n");
	} else {
		pr("You have been defeated!\n");
		wu(0, own, fmt(" & lost %.1f", f38));
		nreport(cnum, N_SCT_LOSE, own, 1);
		r9 = r10 / f40;
		psctv(V_MILIT, r9);
	}
	putsect(f14, f18);
	pr(fmt("Casualties :\012Yours... %.1f\n", f38));
	pr(fmt("Theirs.. %.1f\012", f30));
	btused += (f30 + f38) * 0.15 + 0.5;
	return 0;
}
