static char *RCSid = "$Header: arm.c 1.8 89/03/17 $";

/*
 * arm.c
 *
 * arm planes (missiles) with nuclear devices
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nuke.h"
#include "plane.h"

int
arm()
{
	extern	char *getstarg();
	extern	struct nchrstr nchr[];
	extern	struct plchrstr plchr[];
	extern	char *argp[];
	extern	int nuk_maxno;
	extern	int cnum;
	struct	nchrstr *ncp;
	struct	plchrstr *plc;
	struct	plnstr pl;
	struct	nukstr nuke;
	char	*p;
	int	pno;
	int	nuketype;
	int	nukenum;
	int	len;
	int	i;

	if ((p = getstarg(argp[1], "arm plane : ")) == 0 || *p == 0)
		return RET_SYN;
	pno = atoi(p);
	if (pno < 0 || getplane(pno, &pl) < 0 || pl.pln_own != cnum)
		return RET_FAIL;
	if (pl.pln_nukeamt > 0) {
		pr(fmt("%s #%d is already armed!\n", plchr[pl.pln_type].pl_name,
			pno));
		return RET_FAIL;
	}
	if ((p = getstarg(argp[2], "warhead type : ")) == 0)
		return RET_SYN;
	len = strlen(p);
	for (i=0, ncp = nchr; i<nuk_maxno; i++, ncp++) {
		if (strncmp(ncp->n_name, p, len) == 0)
			break;
	}
	if (i == nuk_maxno) {
		pr("No such nuke type!\n");
		return RET_SYN;
	}
	nuketype = i;
	nukenum = -1;
	for (i=0; getnuke(i, &nuke) == 0; i++) {
		if (nuke.nuk_own != cnum)
			continue;
		if (nuke.nuk_x != pl.pln_x || nuke.nuk_y != pl.pln_y)
			continue;
#ifdef notdef
		if (nuke.nuk_ship >= 0)
			continue;
#endif		
		nukenum = i;
		break;
	}
	if (nukenum < 0) {
		pr("You don't own any nukes in that sector\n");
		return RET_FAIL;
	}
	if (nuke.nuk_types[nuketype] == 0) {
		pr("No nukes of that type in that sector\n");
		return RET_FAIL;
	}
	p = getstarg(argp[3], "number of warheads : ");
	if (p == 0 || *p == 0 || (i = atoi(p)) < 0)
		return RET_FAIL;
	getnuke(nukenum, &nuke);
	if (i > nuke.nuk_types[nuketype])
		i = nuke.nuk_types[nuketype];
	plc = &plchr[pl.pln_type];
	if (plc->pl_load < ncp->n_weight * i) {
		pr(fmt("%s cannot carry %d %s bombs.!\n", plc->pl_name,
			ncp->n_name));
		return RET_FAIL;
	}
	pl.pln_nukeamt = i;
	pl.pln_nuketype = nuketype;
	putplane(pno, &pl);
	nuke.nuk_types[nuketype] -= i;
	nuke.nuk_n -= i;
	if (nuke.nuk_n <= 0)
		nuke.nuk_own = 0;
	putnuke(nukenum, &nuke);
	return RET_OK;
}
