static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/COMS/RCS/add.c,v 1.13 89/05/10 01:54:33 muir Exp $";

/*
 * add.c
 *
 * add a new country to the game.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "tel.h"

add()
{
	extern	char *argp[];
	struct	natstr *natp;
	struct	sctstr sect;
	struct	nstr_sect nstr;
	register int n;
	register int i;
	int	coun;
	char	*p;
	char	loopflag;

	for (n=0; natp = getnatp(n); n++) {
		if ((natp->nat_stat & STAT_INUSE) == 0)
			break;
	}
	for (;;) {
		if (n <= MAXNOC)
			p = fmt("New country number? (%d is unused) ", n);
		else
			p = "New country number? (they all seem to be used) ";
		p = getstarg(argp[1], p);
		if (p == 0 || *p == 0) {
			if (n < MAXNOC) {
				pr(fmt("%d being used\n", n));
				coun = n;
			}
			else	continue;
		} else
			coun = atoi(p);
		break;
	}
	if ((natp = getnatp(coun)) == 0)
		pr(fmt("getnat(%d) == 0\n", coun));
	while (1) {
		p = getstring("Country Name? ");
		if (strlen(p) < 20) {
			NAT_SET(nat_cnam[0], coun, p);
			break;
		}
		pr("Too long.\n");
	}
	while (1) {
		p = getstring("Representative? ");
		if (strlen(p) < 20) {
			NAT_SET(nat_pnam[0], coun, p);
			break;
		}
		pr("Too long.\n");
	}
	loopflag = 1;
	while (loopflag) {
		p = getstring("Status? (visitor, new, active, god, delete) ");
		loopflag = 0;
		switch (*p) {
		case 'v':
			natp->nat_stat = STAT_INUSE;
			break;
		case 'n':
			natp->nat_stat = STAT_NEW|STAT_INUSE;  
			break;
		case 'a':
			natp->nat_stat = STAT_NORM|STAT_INUSE;
			break;
		case 'g':
			natp->nat_stat = STAT_GOD|STAT_NORM|STAT_INUSE;
			break;
		case 'd':
			natp->nat_stat &= (~STAT_INUSE);
			break;
		default:
			pr("Illegal selection\n");
			loopflag = 1;
			break;
		}
	}
	NAT_SET(nat_stat, coun, natp->nat_stat);
	p = getstring("Check, wipe, or ignore existing sectors (c|w|i) ");
	if (*p != 'w' && *p != 'c') {
		pr("Any existing sectors ignored\n");
	} else {
		pr("Checking sectors...\n");
		snxtsct(&nstr, "*");
		while (nxtsct(&nstr, &sect)) {
			if (sect.sct_own != coun)
				continue;
			pr(fmt("%s ", xyas(nstr.x, nstr.y, cnum)));
			if (*p == 'w') {
				sect.sct_mobil = 0;
				sect.sct_effic = 0;
				sect.sct_own = 0;
				sect.sct_oldown = 0;
				if (sect.sct_type != SCT_MOUNT)
					sect.sct_type = SCT_RURAL;
				sect.sct_distpath = 0;
				sect.sct_nv = 0;
				putsect(&sect);
				pr("wiped\n");
			} else {
				pr("\n");
			}
		}
	}
	if ((natp->nat_stat & (STAT_INUSE|STAT_NORM|STAT_GOD)) == STAT_INUSE) {
		NAT_SET(nat_btu, coun, 0);
		NAT_SET(nat_login, coun, 0);
		NAT_SET(nat_reserve, coun, 0);
		NAT_SET(nat_tgms, coun, 0);
		NAT_SET(nat_ycap, coun, 0);
		NAT_SET(nat_xcap, coun, 0);
		NAT_SET(nat_yorg, coun, 0);
		NAT_SET(nat_xorg, coun, 0);
		NAT_SET(nat_dayno, coun, 0);
		NAT_SET(nat_minused, coun, 0);
		bzero(natp->nat_b, sizeof(natp->nat_b));
		for (i=0; i < MAXNOR; i++)
			NAT_SETARY(nat_b[0], coun, i, natp->nat_b);
		(void) time(&natp->nat_date);
		NAT_SET(nat_date, coun, natp->nat_date);
		NAT_SET(nat_money, coun, 0);
		for (i=0; i<MAXNOC/8; i++)
			NAT_SETARY(nat_relate[0], coun, i, 0);
		for (i=0; i<4; i++)
			NAT_SETARY(nat_level[0], coun, i, 0.0);
		NAT_SET(nat_newstim, coun, 0);
		(void) creat(mailbox(coun), 0660);
	} else
		pr("No special initializations done...\n");
	return 0;
}
